/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment.client;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.impl.attachment.AttachmentEntrypoint;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentChange;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentSync;
import net.fabricmc.fabric.impl.attachment.sync.AttachmentSyncException;
import net.fabricmc.fabric.impl.attachment.sync.s2c.AttachmentSyncPayloadS2C;
import net.fabricmc.fabric.impl.attachment.sync.s2c.RequestAcceptedAttachmentsPayloadS2C;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;

public class AttachmentSyncClient
implements ClientModInitializer {
    public void onInitializeClient() {
        ClientConfigurationNetworking.registerGlobalReceiver(RequestAcceptedAttachmentsPayloadS2C.ID, (payload, context) -> context.responseSender().sendPacket((CustomPacketPayload)AttachmentSync.createResponsePayload()));
        ClientPlayNetworking.registerGlobalReceiver(AttachmentSyncPayloadS2C.ID, (payload, context) -> {
            for (AttachmentChange attachmentChange : payload.attachments()) {
                try {
                    attachmentChange.tryApply((Level)context.client().level);
                }
                catch (AttachmentSyncException e) {
                    AttachmentEntrypoint.LOGGER.error("Error accepting attachment changes", (Throwable)e);
                    context.responseSender().disconnect(e.getText());
                    break;
                }
            }
        });
    }
}

