/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.attachment;

import com.mojang.serialization.Codec;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentSyncPredicate;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.impl.attachment.AttachmentTypeImpl;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.Identifier;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AttachmentRegistryImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-data-attachment-api-v1");
    private static final Map<Identifier, AttachmentType<?>> attachmentRegistry = new HashMap();
    private static final Set<Identifier> syncableAttachments = new HashSet<Identifier>();
    private static final Set<Identifier> syncableView = Collections.unmodifiableSet(syncableAttachments);

    public static <A> void register(Identifier id, AttachmentType<A> attachmentType) {
        AttachmentType<A> existing = attachmentRegistry.put(id, attachmentType);
        if (existing != null) {
            LOGGER.warn("Encountered duplicate type registration for id {}", (Object)id);
            if (existing.isSynced() && !attachmentType.isSynced()) {
                syncableAttachments.remove(id);
            } else if (!existing.isSynced() && attachmentType.isSynced()) {
                syncableAttachments.add(id);
            }
        } else if (attachmentType.isSynced()) {
            syncableAttachments.add(id);
        }
    }

    public static @Nullable AttachmentType<?> get(Identifier id) {
        return attachmentRegistry.get(id);
    }

    public static Set<Identifier> getSyncableAttachments() {
        return syncableView;
    }

    public static <A> AttachmentRegistry.Builder<A> builder() {
        return new BuilderImpl();
    }

    public static class BuilderImpl<A>
    implements AttachmentRegistry.Builder<A> {
        private @Nullable Supplier<A> defaultInitializer = null;
        private @Nullable Codec<A> persistenceCodec = null;
        private @Nullable StreamCodec<? super RegistryFriendlyByteBuf, A> packetCodec = null;
        private @Nullable AttachmentSyncPredicate syncPredicate = null;
        private boolean copyOnDeath = false;

        @Override
        public AttachmentRegistry.Builder<A> persistent(Codec<A> codec) {
            Objects.requireNonNull(codec, "codec cannot be null");
            this.persistenceCodec = codec;
            return this;
        }

        @Override
        public AttachmentRegistry.Builder<A> copyOnDeath() {
            this.copyOnDeath = true;
            return this;
        }

        @Override
        public AttachmentRegistry.Builder<A> initializer(Supplier<A> initializer) {
            Objects.requireNonNull(initializer, "initializer cannot be null");
            this.defaultInitializer = initializer;
            return this;
        }

        @Override
        @Deprecated
        public AttachmentRegistry.Builder<A> syncWith(StreamCodec<? super RegistryFriendlyByteBuf, A> packetCodec, AttachmentSyncPredicate syncPredicate) {
            Objects.requireNonNull(packetCodec, "packet codec cannot be null");
            Objects.requireNonNull(syncPredicate, "sync predicate cannot be null");
            this.packetCodec = packetCodec;
            this.syncPredicate = syncPredicate;
            return this;
        }

        @Override
        public AttachmentType<A> buildAndRegister(Identifier id) {
            Objects.requireNonNull(id, "identifier cannot be null");
            if (this.syncPredicate != null && id.toString().length() > 256) {
                throw new IllegalArgumentException("Identifier length is too long for a synced attachment type (was %d, maximum is %d)".formatted(id.toString().length(), 256));
            }
            AttachmentTypeImpl<A> attachment = new AttachmentTypeImpl<A>(id, this.defaultInitializer, this.persistenceCodec, this.packetCodec, this.syncPredicate, this.copyOnDeath);
            AttachmentRegistryImpl.register(id, attachment);
            return attachment;
        }
    }
}

