/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registry;

import com.mojang.serialization.MapCodec;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import net.fabricmc.fabric.impl.content.registry.OxidizableBlocksRegistryImpl;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2688;
import net.minecraft.class_2769;
import net.minecraft.class_4970;

@Mixin(class_4970.class_4971.class)
public abstract class AbstractBlockAbstractBlockStateMixin extends class_2688<class_2248, class_2680> implements OxidizableBlocksRegistryImpl.RandomTickCacheRefresher {
	@Shadow
	private boolean ticksRandomly;

	private AbstractBlockAbstractBlockStateMixin(class_2248 owner, Reference2ObjectArrayMap<class_2769<?>, Comparable<?>> propertyMap, MapCodec<class_2680> codec) {
		super(owner, propertyMap, codec);
	}

	@Override
	public void fabric_api$refreshRandomTickCache() {
		this.ticksRandomly = ((AbstractBlockAccessor) this.field_24739).callHasRandomTicks(this.asBlockState());
	}

	@Shadow
	protected class_2680 asBlockState() {
		return null;
	}
}
