/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.content.registry;

import java.util.List;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.api.registry.FabricBrewingRecipeRegistryBuilder;
import net.minecraft.class_1792;
import net.minecraft.class_1842;
import net.minecraft.class_1845;
import net.minecraft.class_1847;
import net.minecraft.class_1856;
import net.minecraft.class_6880;
import net.minecraft.class_7699;

@Mixin(class_1845.class_9665.class)
public abstract class PotionBrewingBuilderMixin implements FabricBrewingRecipeRegistryBuilder {
	@Shadow
	@Final
	private class_7699 enabledFeatures;

	@Shadow
	private static void expectPotion(class_1792 potionType) {
	}

	@Shadow
	@Final
	private List<class_1845.class_1846<class_1792>> containerMixes;

	@Shadow
	@Final
	private List<class_1845.class_1846<class_1842>> potionMixes;

	@Inject(method = "build", at = @At("HEAD"))
	private void build(CallbackInfoReturnable<class_1845> cir) {
		FabricBrewingRecipeRegistryBuilder.BUILD.invoker().build((class_1845.class_9665) (Object) this);
	}

	@Override
	public void registerItemRecipe(class_1792 input, class_1856 ingredient, class_1792 output) {
		if (input.method_45382(this.enabledFeatures) && output.method_45382(this.enabledFeatures)) {
			expectPotion(input);
			expectPotion(output);
			this.containerMixes.add(new class_1845.class_1846<>(input.method_40131(), ingredient, output.method_40131()));
		}
	}

	@Override
	public void registerPotionRecipe(class_6880<class_1842> input, class_1856 ingredient, class_6880<class_1842> output) {
		if (input.comp_349().method_45382(this.enabledFeatures) && output.comp_349().method_45382(this.enabledFeatures)) {
			this.potionMixes.add(new class_1845.class_1846<>(input, ingredient, output));
		}
	}

	@Override
	public void registerRecipes(class_1856 ingredient, class_6880<class_1842> potion) {
		if (potion.comp_349().method_45382(this.enabledFeatures)) {
			this.registerPotionRecipe(class_1847.field_8991, ingredient, class_1847.field_8967);
			this.registerPotionRecipe(class_1847.field_8999, ingredient, potion);
		}
	}

	@Override
	public class_7699 getEnabledFeatures() {
		return this.enabledFeatures;
	}
}
