/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.client.gametest.threading;

import com.llamalad7.mixinextras.injector.wrapmethod.WrapMethod;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import io.netty.channel.ChannelHandlerContext;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import net.fabricmc.fabric.impl.client.gametest.threading.NetworkSynchronizer;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_2598;

@Mixin(class_2535.class)
public class ConnectionMixin {
	@Shadow
	@Final
	private class_2598 receiving;

	@WrapMethod(method = "channelRead0(Lio/netty/channel/ChannelHandlerContext;Lnet/minecraft/network/protocol/Packet;)V")
	private void onNettyReceivePacket(ChannelHandlerContext context, class_2596<?> packet, Operation<Void> original) {
		NetworkSynchronizer synchronizer = receiving == class_2598.field_11942 ? NetworkSynchronizer.CLIENTBOUND : NetworkSynchronizer.SERVERBOUND;
		synchronizer.preNettyHandlePacket();

		try {
			original.call(context, packet);
		} finally {
			synchronizer.postNettyHandlePacket();
		}
	}

	@Inject(method = "sendPacket", at = @At("HEAD"))
	private void onSendPacket(CallbackInfo ci) {
		NetworkSynchronizer synchronizer = receiving == class_2598.field_11942 ? NetworkSynchronizer.SERVERBOUND : NetworkSynchronizer.CLIENTBOUND;
		synchronizer.preSendPacket();
	}
}
