/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.client.gametest.context;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.gametest.v1.context.ClientGameTestContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestClientWorldContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestServerContext;
import net.fabricmc.fabric.api.client.gametest.v1.context.TestSingleplayerContext;
import net.fabricmc.fabric.api.client.gametest.v1.world.TestWorldSave;
import net.fabricmc.fabric.impl.client.gametest.context.TestClientWorldContextImpl;
import net.fabricmc.fabric.impl.client.gametest.context.TestServerContextImpl;
import net.fabricmc.fabric.impl.client.gametest.threading.ThreadingImpl;
import net.minecraft.class_2561;
import net.minecraft.class_424;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.server.MinecraftServer;

@Environment(value=EnvType.CLIENT)
public class TestSingleplayerContextImpl
implements TestSingleplayerContext {
    private final ClientGameTestContext context;
    private final TestWorldSave worldSave;
    private final TestClientWorldContext clientWorld;
    private final TestServerContext server;

    public TestSingleplayerContextImpl(ClientGameTestContext context, TestWorldSave worldSave, MinecraftServer server) {
        this.context = context;
        this.worldSave = worldSave;
        this.clientWorld = new TestClientWorldContextImpl(context);
        this.server = new TestServerContextImpl(server);
    }

    @Override
    public TestWorldSave getWorldSave() {
        return this.worldSave;
    }

    @Override
    public TestClientWorldContext getClientWorld() {
        return this.clientWorld;
    }

    @Override
    public TestServerContext getServer() {
        return this.server;
    }

    @Override
    public void close() {
        ThreadingImpl.checkOnGametestThread("close");
        this.context.runOnClient(client -> {
            if (client.field_1687 == null) {
                throw new IllegalStateException("Exited the world before closing singleplayer context");
            }
            client.field_1687.method_8525((class_2561)class_2561.method_43471((String)"menu.savingLevel"));
            client.method_18096((class_437)new class_424((class_2561)class_2561.method_43471((String)"menu.savingLevel")), false);
        });
        this.context.waitFor(client -> !ThreadingImpl.isServerRunning && client.field_1687 == null, 1200);
        this.context.setScreen(class_442::new);
    }
}

