/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.fabric.mixin.biome;

import java.util.List;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import net.fabricmc.fabric.impl.biome.MultiNoiseSamplerHooks;
import net.minecraft.class_5284;
import net.minecraft.class_5309;
import net.minecraft.class_6350;
import net.minecraft.class_6544;
import net.minecraft.class_6568;
import net.minecraft.class_6748;
import net.minecraft.class_6916;
import net.minecraft.class_6953;
import net.minecraft.class_7138;

@Mixin(class_6568.class)
public class NoiseChunkMixin {
	@Unique
	private long seed;

	@Inject(method = "<init>", at = @At("TAIL"))
	private void init(int horizontalSize, class_7138 noiseConfig, int i, int j, class_5309 generationShapeConfig, class_6916.class_7050 arg, class_5284 chunkGeneratorSettings, class_6350.class_6565 fluidLevelSampler, class_6748 blender, CallbackInfo ci) {
		seed = ((MultiNoiseSamplerHooks) (Object) noiseConfig.method_42371()).fabric_getSeed();
	}

	@Inject(method = "cachedClimateSampler", at = @At("RETURN"))
	private void createMultiNoiseSampler(class_6953 noiseRouter, List<class_6544.class_4762> list, CallbackInfoReturnable<class_6544.class_6552> cir) {
		((MultiNoiseSamplerHooks) (Object) cir.getReturnValue()).fabric_setSeed(seed);
	}
}
