/*
 * Copyright (c) 2020 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.fabricmc.classtweaker.api;

import org.jetbrains.annotations.ApiStatus;

import net.fabricmc.classtweaker.api.visitor.ClassTweakerVisitor;
import net.fabricmc.classtweaker.writer.ClassTweakerWriterImpl;

@ApiStatus.NonExtendable
public interface ClassTweakerWriter extends ClassTweakerVisitor {
	static ClassTweakerWriter create(int version) {
		return new ClassTweakerWriterImpl(version);
	}

	byte[] getOutput();

	String getOutputAsString();
}
