/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.vineflower;

import cuchaz.enigma.classprovider.ClassProvider;
import cuchaz.enigma.utils.AsmUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.java.decompiler.main.extern.IContextSource;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.objectweb.asm.tree.ClassNode;

class VineflowerContextSource
implements IContextSource {
    private final IContextSource classpathSource = new ClasspathSource();
    private final ClassProvider classProvider;
    private final String className;
    private IContextSource.Entries entries;

    VineflowerContextSource(ClassProvider classProvider, String className) {
        this.classProvider = classProvider;
        this.className = className;
    }

    public IContextSource getClasspath() {
        return this.classpathSource;
    }

    public String getName() {
        return "Enigma-provided context for class " + this.className;
    }

    public IContextSource.Entries getEntries() {
        this.computeEntriesIfNecessary();
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeEntriesIfNecessary() {
        if (this.entries != null) {
            return;
        }
        VineflowerContextSource vineflowerContextSource = this;
        synchronized (vineflowerContextSource) {
            if (this.entries != null) {
                return;
            }
            ArrayList<String> classNames = new ArrayList<String>();
            classNames.add(this.className);
            int dollarIndex = this.className.indexOf(36);
            String outermostClass = dollarIndex == -1 ? this.className : this.className.substring(0, this.className.indexOf(36));
            String outermostClassSuffixed = outermostClass + "$";
            for (String currentClass : this.classProvider.getClassNames()) {
                if (!currentClass.startsWith(outermostClassSuffixed) || currentClass.equals(this.className)) continue;
                classNames.add(currentClass);
            }
            List<IContextSource.Entry> classes = classNames.stream().map(IContextSource.Entry::atBase).toList();
            this.entries = new IContextSource.Entries(classes, Collections.emptyList(), Collections.emptyList());
        }
    }

    public InputStream getInputStream(String resource) {
        ClassNode node = this.classProvider.get(resource.substring(0, resource.lastIndexOf(".class")));
        if (node == null) {
            return null;
        }
        return new ByteArrayInputStream(AsmUtil.nodeToBytes(node));
    }

    public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
        return new IContextSource.IOutputSink(){

            public void begin() {
            }

            public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                if (qualifiedName.equals(VineflowerContextSource.this.className)) {
                    saver.saveClassFile(null, qualifiedName, fileName, content, mapping);
                }
            }

            public void acceptDirectory(String directory) {
            }

            public void acceptOther(String path) {
            }

            public void close() {
            }
        };
    }

    public class ClasspathSource
    implements IContextSource {
        public String getName() {
            return "Enigma-provided classpath context for " + VineflowerContextSource.this.className;
        }

        public IContextSource.Entries getEntries() {
            return IContextSource.Entries.EMPTY;
        }

        public boolean isLazy() {
            return true;
        }

        public InputStream getInputStream(String resource) {
            return VineflowerContextSource.this.getInputStream(resource);
        }
    }
}

