/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import cuchaz.enigma.analysis.BetterAnalyzerAdapter;
import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.translation.representation.entry.ParentedEntry;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class IndexReferenceVisitor
extends ClassVisitor {
    private final JarIndexer indexer;
    private ClassEntry classEntry;
    private String className;

    public IndexReferenceVisitor(JarIndexer indexer, int api) {
        super(api);
        this.indexer = indexer;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.classEntry = new ClassEntry(name);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDefEntry entry = new MethodDefEntry(this.classEntry, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access));
        return new IndexReferenceMethodVisitor(this.api, this.className, access, name, desc, entry, this.indexer);
    }

    private static class IndexReferenceMethodVisitor
    extends BetterAnalyzerAdapter {
        private final MethodDefEntry callerEntry;
        private final JarIndexer indexer;

        IndexReferenceMethodVisitor(int api, String owner, int access, String name, String descriptor, MethodDefEntry callerEntry, JarIndexer indexer) {
            super(api, owner, access, name, descriptor, null);
            this.callerEntry = callerEntry;
            this.indexer = indexer;
        }

        public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
            switch (opcode) {
                case 178: 
                case 179: {
                    this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(owner, name, descriptor), ReferenceTargetType.none());
                    break;
                }
                case 180: {
                    this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(owner, name, descriptor), this.getReferenceTargetType(0));
                    break;
                }
                case 181: {
                    this.indexer.indexFieldReference(this.callerEntry, FieldEntry.parse(owner, name, descriptor), this.getReferenceTargetType(Type.getType((String)descriptor).getSize()));
                }
            }
            super.visitFieldInsn(opcode, owner, name, descriptor);
        }

        public void visitLdcInsn(Object value) {
            Type type;
            if (value instanceof Type && ((type = (Type)value).getSort() == 10 || type.getSort() == 9)) {
                if (type.getSort() == 9) {
                    type = type.getElementType();
                }
                this.indexer.indexClassReference(this.callerEntry, ClassEntry.parse(type.getInternalName()), ReferenceTargetType.none());
            }
            super.visitLdcInsn(value);
        }

        public void visitTypeInsn(int opcode, String type) {
            if (opcode == 193 || opcode == 192) {
                Type classType = Type.getObjectType((String)type);
                if (classType.getSort() == 9) {
                    classType = classType.getElementType();
                }
                this.indexer.indexClassReference(this.callerEntry, ClassEntry.parse(classType.getInternalName()), ReferenceTargetType.none());
            }
            super.visitTypeInsn(opcode, type);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
            ReferenceTargetType targetType;
            if (opcode == 184) {
                targetType = ReferenceTargetType.none();
            } else {
                int argSize = (Type.getArgumentsAndReturnSizes((String)descriptor) >> 2) - 1;
                targetType = this.getReferenceTargetType(argSize);
            }
            this.indexer.indexMethodReference(this.callerEntry, MethodEntry.parse(owner, name, descriptor), targetType);
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }

        public void visitInvokeDynamicInsn(String name, String descriptor, Handle bootstrapMethodHandle, Object ... bootstrapMethodArguments) {
            if ("java/lang/invoke/LambdaMetafactory".equals(bootstrapMethodHandle.getOwner()) && ("metafactory".equals(bootstrapMethodHandle.getName()) || "altMetafactory".equals(bootstrapMethodHandle.getName()))) {
                ReferenceTargetType targetType;
                Type samMethodType = (Type)bootstrapMethodArguments[0];
                Handle implMethod = (Handle)bootstrapMethodArguments[1];
                Type instantiatedMethodType = (Type)bootstrapMethodArguments[2];
                if (implMethod.getTag() != 2 && implMethod.getTag() != 3 && implMethod.getTag() != 6) {
                    if (instantiatedMethodType.getArgumentCount() < Type.getArgumentCount((String)implMethod.getDesc())) {
                        if (descriptor.startsWith("(L")) {
                            int argSize = (Type.getArgumentsAndReturnSizes((String)descriptor) >> 2) - 1;
                            targetType = this.getReferenceTargetType(argSize - 1);
                        } else {
                            targetType = ReferenceTargetType.none();
                        }
                    } else {
                        targetType = ReferenceTargetType.none();
                    }
                } else {
                    targetType = ReferenceTargetType.none();
                }
                this.indexer.indexLambda(this.callerEntry, new Lambda(name, new MethodDescriptor(descriptor), new MethodDescriptor(samMethodType.getDescriptor()), IndexReferenceMethodVisitor.getHandleEntry(implMethod), new MethodDescriptor(instantiatedMethodType.getDescriptor())), targetType);
            }
            super.visitInvokeDynamicInsn(name, descriptor, bootstrapMethodHandle, bootstrapMethodArguments);
        }

        private ReferenceTargetType getReferenceTargetType(int stackDepth) {
            if (stackDepth >= this.stack.size()) {
                throw new IllegalStateException("Stack depth " + stackDepth + " is higher than the stack: " + IndexReferenceMethodVisitor.stackValuesToString(this.stack) + " in method " + String.valueOf(this.callerEntry));
            }
            Object stackValue = this.stack.get(this.stack.size() - 1 - stackDepth);
            if (stackValue.equals(Opcodes.UNINITIALIZED_THIS) || stackValue instanceof Label) {
                return ReferenceTargetType.uninitialized();
            }
            if (!(stackValue instanceof String)) {
                throw new IllegalStateException("Illegal stack value in method " + String.valueOf(this.callerEntry) + ": " + IndexReferenceMethodVisitor.stackValuesToString(List.of(stackValue)));
            }
            String type = (String)stackValue;
            if (type.startsWith("[")) {
                return ReferenceTargetType.classType(new ClassEntry("java/lang/Object"));
            }
            return ReferenceTargetType.classType(new ClassEntry(type));
        }

        private static String stackValuesToString(List<Object> stack) {
            StringBuilder result = new StringBuilder("[");
            boolean first = true;
            for (Object stackValue : stack) {
                if (first) {
                    first = false;
                } else {
                    result.append(", ");
                }
                if (stackValue instanceof String) {
                    String str = (String)stackValue;
                    result.append(str);
                    continue;
                }
                if (stackValue instanceof Integer) {
                    Integer i = (Integer)stackValue;
                    result.append("TIFDJNU".charAt(i));
                    continue;
                }
                if (stackValue instanceof Label) {
                    result.append('U');
                    continue;
                }
                throw new AssertionError((Object)("Illegal stack value type: " + stackValue.getClass().getName()));
            }
            return result.append(']').toString();
        }

        private static ParentedEntry<?> getHandleEntry(Handle handle) {
            return switch (handle.getTag()) {
                case 1, 2, 3, 4 -> FieldEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                case 5, 6, 7, 8, 9 -> MethodEntry.parse(handle.getOwner(), handle.getName(), handle.getDesc());
                default -> throw new RuntimeException("Invalid handle tag " + handle.getTag());
            };
        }
    }
}

