/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import cuchaz.enigma.analysis.index.EntryIndex;
import cuchaz.enigma.translation.representation.entry.ClassDefEntry;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class IndexClassWriter
extends ClassWriter {
    private final EntryIndex entryIndex;

    public IndexClassWriter(EntryIndex entryIndex, int flags) {
        super(flags);
        this.entryIndex = entryIndex;
    }

    protected String getCommonSuperClass(String type1, String type2) {
        ClassInfo info1 = this.getClassInfo(type1);
        ClassInfo info2 = this.getClassInfo(type2);
        if (info1 == null || info2 == null) {
            return "java/lang/Object";
        }
        if (this.isAssignable(info1, info2)) {
            return type1;
        }
        if (this.isAssignable(info2, info1)) {
            return type2;
        }
        if (info1.isInterface() || info2.isInterface()) {
            return "java/lang/Object";
        }
        while ((info1 = info1.getSuperClass()) != null && !this.isAssignable(info1, info2)) {
        }
        return info1 == null ? "java/lang/Object" : info1.getName();
    }

    private boolean isAssignable(ClassInfo left, ClassInfo right) {
        String leftName = left.getName();
        while (right != null) {
            if (right.getName().equals(leftName)) {
                return true;
            }
            right = right.getSuperClass();
        }
        return false;
    }

    @Nullable
    private ClassInfo getClassInfo(String internalName) {
        Class<?> clazz;
        ClassDefEntry defEntry = this.entryIndex.getDefinition(new ClassEntry(internalName));
        if (defEntry != null) {
            return new ClassDefEntryInfo(defEntry);
        }
        try {
            clazz = Class.forName(internalName.replace('/', '.'), false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        return new ReflectionClassInfo(clazz);
    }

    private static interface ClassInfo {
        public String getName();

        @Nullable
        public ClassInfo getSuperClass();

        public boolean isInterface();
    }

    private class ClassDefEntryInfo
    implements ClassInfo {
        private final ClassDefEntry entry;

        private ClassDefEntryInfo(ClassDefEntry entry) {
            this.entry = entry;
        }

        @Override
        public String getName() {
            return this.entry.getFullName();
        }

        @Override
        @Nullable
        public ClassInfo getSuperClass() {
            ClassEntry superClass = this.entry.getSuperClass();
            if (superClass == null) {
                return null;
            }
            return IndexClassWriter.this.getClassInfo(superClass.getFullName());
        }

        @Override
        public boolean isInterface() {
            return this.entry.getAccess().isInterface();
        }
    }

    private record ReflectionClassInfo(Class<?> clazz) implements ClassInfo
    {
        @Override
        public String getName() {
            return Type.getInternalName(this.clazz);
        }

        @Override
        @Nullable
        public ClassInfo getSuperClass() {
            Class<Object> superClass = this.clazz.isInterface() ? Object.class : this.clazz.getSuperclass();
            return superClass == null ? null : new ReflectionClassInfo(superClass);
        }

        @Override
        public boolean isInterface() {
            return this.clazz.isInterface();
        }
    }
}

