/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import javax.annotation.Nullable;

public class FieldDefEntry
extends FieldEntry
implements DefEntry<ClassEntry> {
    private final AccessFlags access;
    private final Signature signature;

    public FieldDefEntry(ClassEntry owner, String name, TypeDescriptor desc, Signature signature, AccessFlags access) {
        this(owner, name, desc, signature, access, null);
    }

    public FieldDefEntry(ClassEntry owner, String name, TypeDescriptor desc, Signature signature, AccessFlags access, String javadocs) {
        super(owner, name, desc, javadocs);
        Preconditions.checkNotNull((Object)access, (Object)"Field access cannot be null");
        Preconditions.checkNotNull((Object)signature, (Object)"Field signature cannot be null");
        this.access = access;
        this.signature = signature;
    }

    public static FieldDefEntry parse(ClassEntry owner, int access, String name, String desc, String signature) {
        return new FieldDefEntry(owner, name, new TypeDescriptor(desc), Signature.createTypedSignature(signature), new AccessFlags(access), null);
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    protected TranslateResult<FieldEntry> extendedTranslate(Translator translator, @Nullable EntryMapping mapping) {
        TypeDescriptor translatedDesc = translator.translate(this.desc);
        Signature translatedSignature = translator.translate(this.signature);
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        AccessFlags translatedAccess = mapping != null ? mapping.getAccessModifier().transform(this.access) : this.access;
        String docs = mapping != null ? mapping.getJavadoc() : null;
        return TranslateResult.of(mapping == null ? RenamableTokenType.OBFUSCATED : RenamableTokenType.DEOBFUSCATED, new FieldDefEntry((ClassEntry)this.parent, translatedName, translatedDesc, translatedSignature, translatedAccess, docs));
    }

    @Override
    public FieldDefEntry withName(String name) {
        return new FieldDefEntry((ClassEntry)this.parent, name, this.desc, this.signature, this.access, this.javadocs);
    }

    @Override
    public FieldDefEntry withParent(ClassEntry owner) {
        return new FieldDefEntry(owner, this.name, this.desc, this.signature, this.access, this.javadocs);
    }
}

