/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.mapping.tree;

import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface EntryTreeNode<T> {
    @Nullable
    public T getValue();

    public Entry<?> getEntry();

    public boolean isEmpty();

    public Collection<Entry<?>> getChildren();

    public Collection<? extends EntryTreeNode<T>> getChildNodes();

    default public Collection<? extends EntryTreeNode<T>> getNodesRecursively() {
        ArrayList<EntryTreeNode<T>> nodes = new ArrayList<EntryTreeNode<T>>();
        nodes.add(this);
        for (EntryTreeNode<T> node : this.getChildNodes()) {
            nodes.addAll(node.getNodesRecursively());
        }
        return nodes;
    }

    default public Collection<Entry<?>> getChildrenRecursively() {
        return this.getNodesRecursively().stream().map(EntryTreeNode::getEntry).collect(Collectors.toList());
    }

    default public boolean hasValue() {
        return this.getValue() != null;
    }
}

