/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.source.SourceRemapper;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SourceIndex {
    private String source;
    private List<Integer> lineOffsets;
    private final TreeMap<Token, EntryReference<Entry<?>, Entry<?>>> tokenToReference = new TreeMap();
    private final Multimap<EntryReference<Entry<?>, Entry<?>>, Token> referenceToTokens = HashMultimap.create();
    private final Map<Entry<?>, Token> declarationToToken = Maps.newHashMap();

    public SourceIndex() {
    }

    public SourceIndex(String source) {
        this();
        this.setSource(source);
    }

    public void setSource(String source) {
        this.source = source;
        this.lineOffsets = Lists.newArrayList();
        this.lineOffsets.add(0);
        for (int i = 0; i < this.source.length(); ++i) {
            if (this.source.charAt(i) != '\n') continue;
            this.lineOffsets.add(i + 1);
        }
    }

    public String getSource() {
        return this.source;
    }

    public int getLineNumber(int position) {
        int offset;
        int line = 0;
        Iterator<Integer> iterator = this.lineOffsets.iterator();
        while (iterator.hasNext() && (offset = iterator.next().intValue()) <= position) {
            ++line;
        }
        return line;
    }

    public int getColumnNumber(int position) {
        return position - this.lineOffsets.get(this.getLineNumber(position) - 1) + 1;
    }

    public int getPosition(int line, int column) {
        return this.lineOffsets.get(line - 1) + column - 1;
    }

    public Iterable<Entry<?>> declarations() {
        return this.declarationToToken.keySet();
    }

    public Iterable<Token> declarationTokens() {
        return this.declarationToToken.values();
    }

    public Token getDeclarationToken(Entry<?> entry) {
        return this.declarationToToken.get(entry);
    }

    public void addDeclaration(Token token, Entry<?> deobfEntry) {
        if (token != null) {
            EntryReference reference = new EntryReference(deobfEntry, token.text);
            this.tokenToReference.put(token, reference);
            this.referenceToTokens.put(reference, (Object)token);
            this.declarationToToken.put(deobfEntry, token);
        }
    }

    public Iterable<EntryReference<Entry<?>, Entry<?>>> references() {
        return this.referenceToTokens.keySet();
    }

    public EntryReference<Entry<?>, Entry<?>> getReference(Token token) {
        if (token == null) {
            return null;
        }
        return this.tokenToReference.get(token);
    }

    public Iterable<Token> referenceTokens() {
        return this.tokenToReference.keySet();
    }

    public Token getReferenceToken(int pos) {
        Token token = this.tokenToReference.floorKey(new Token(pos, pos, null));
        if (token != null && token.contains(pos)) {
            return token;
        }
        return null;
    }

    public Collection<Token> getReferenceTokens(EntryReference<Entry<?>, Entry<?>> deobfReference) {
        return this.referenceToTokens.get(deobfReference);
    }

    public void addReference(Token token, Entry<?> deobfEntry, Entry<?> deobfContext) {
        if (token != null) {
            EntryReference deobfReference = new EntryReference(deobfEntry, token.text, deobfContext);
            this.tokenToReference.put(token, deobfReference);
            this.referenceToTokens.put(deobfReference, (Object)token);
        }
    }

    public void resolveReferences(EntryResolver resolver) {
        for (Token token : Lists.newArrayList((Iterable)this.referenceToTokens.values())) {
            EntryReference<Entry<?>, Entry<?>> reference = this.tokenToReference.get(token);
            EntryReference<Entry<?>, Entry<?>> resolvedReference = resolver.resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
            this.tokenToReference.replace(token, resolvedReference);
            Collection tokens = this.referenceToTokens.removeAll(reference);
            this.referenceToTokens.putAll(resolvedReference, (Iterable)tokens);
        }
    }

    public SourceIndex remapTo(SourceRemapper.Result result) {
        SourceIndex remapped = new SourceIndex(result.getSource());
        for (Map.Entry<Entry<?>, Token> entry : this.declarationToToken.entrySet()) {
            remapped.declarationToToken.put(entry.getKey(), result.getRemappedToken(entry.getValue()));
        }
        for (Map.Entry<Entry<Object>, Token> entry : this.referenceToTokens.asMap().entrySet()) {
            EntryReference reference = (EntryReference)((Object)entry.getKey());
            Collection oldTokens = (Collection)((Object)entry.getValue());
            Collection newTokens = oldTokens.stream().map(result::getRemappedToken).collect(Collectors.toList());
            remapped.referenceToTokens.putAll((Object)reference, (Iterable)newTokens);
        }
        for (Map.Entry<Object, Object> entry : this.tokenToReference.entrySet()) {
            remapped.tokenToReference.put(result.getRemappedToken((Token)entry.getKey()), (EntryReference<Entry<?>, Entry<?>>)entry.getValue());
        }
        return remapped;
    }
}

