/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.classprovider;

import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.bytecode.translators.LocalVariableFixVisitor;
import cuchaz.enigma.bytecode.translators.SourceFixVisitor;
import cuchaz.enigma.classprovider.ClassProvider;
import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class ObfuscationFixClassProvider
implements ClassProvider {
    private final ClassProvider classProvider;
    private final JarIndex jarIndex;

    public ObfuscationFixClassProvider(ClassProvider classProvider, JarIndex jarIndex) {
        this.classProvider = classProvider;
        this.jarIndex = jarIndex;
    }

    @Override
    @Nullable
    public ClassNode get(String name) {
        ClassNode fixedNode;
        ClassNode node = this.classProvider.get(name);
        if (!this.jarIndex.isIndexed(name)) {
            return node;
        }
        Object visitor = fixedNode = new ClassNode();
        visitor = new LocalVariableFixVisitor(524288, (ClassVisitor)visitor);
        visitor = new SourceFixVisitor(524288, (ClassVisitor)visitor, this.jarIndex);
        node.accept((ClassVisitor)visitor);
        this.removeRedundantClassCalls(fixedNode);
        return fixedNode;
    }

    private void removeRedundantClassCalls(ClassNode node) {
        for (MethodNode methodNode : node.methods) {
            for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
                if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (!methodInsnNode.name.equals("getClass") || !methodInsnNode.owner.equals("java/lang/Object") || !methodInsnNode.desc.equals("()Ljava/lang/Class;")) continue;
                AbstractInsnNode previous = methodInsnNode.getPrevious();
                AbstractInsnNode next = methodInsnNode.getNext();
                if (previous.getOpcode() != 89 || next.getOpcode() != 87) continue;
                insnNode = previous.getPrevious();
                methodNode.instructions.remove(previous);
                methodNode.instructions.remove((AbstractInsnNode)methodInsnNode);
                methodNode.instructions.remove(next);
            }
        }
    }
}

