/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis.index;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.ReferenceTargetType;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.analysis.index.JarIndexer;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.Lambda;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.FieldDefEntry;
import cuchaz.enigma.translation.representation.entry.FieldEntry;
import cuchaz.enigma.translation.representation.entry.MethodDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.Collection;
import java.util.Map;

public class ReferenceIndex
implements JarIndexer {
    private Multimap<MethodEntry, MethodEntry> methodReferences = HashMultimap.create();
    private Multimap<MethodEntry, EntryReference<MethodEntry, MethodDefEntry>> referencesToMethods = HashMultimap.create();
    private Multimap<ClassEntry, EntryReference<ClassEntry, MethodDefEntry>> referencesToClasses = HashMultimap.create();
    private Multimap<FieldEntry, EntryReference<FieldEntry, MethodDefEntry>> referencesToFields = HashMultimap.create();
    private Multimap<ClassEntry, EntryReference<ClassEntry, FieldDefEntry>> fieldTypeReferences = HashMultimap.create();
    private Multimap<ClassEntry, EntryReference<ClassEntry, MethodDefEntry>> methodTypeReferences = HashMultimap.create();

    @Override
    public void indexMethod(MethodDefEntry methodEntry) {
        this.indexMethodDescriptor(methodEntry, methodEntry.getDesc());
    }

    private void indexMethodDescriptor(MethodDefEntry entry, MethodDescriptor descriptor) {
        for (TypeDescriptor typeDescriptor : descriptor.getArgumentDescs()) {
            this.indexMethodTypeDescriptor(entry, typeDescriptor);
        }
        this.indexMethodTypeDescriptor(entry, descriptor.getReturnDesc());
    }

    private void indexMethodTypeDescriptor(MethodDefEntry method, TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isType()) {
            ClassEntry referencedClass = typeDescriptor.getTypeEntry();
            this.methodTypeReferences.put((Object)referencedClass, new EntryReference<ClassEntry, MethodDefEntry>(referencedClass, referencedClass.getName(), method));
        } else if (typeDescriptor.isArray()) {
            this.indexMethodTypeDescriptor(method, typeDescriptor.getArrayType());
        }
    }

    @Override
    public void indexField(FieldDefEntry fieldEntry) {
        this.indexFieldTypeDescriptor(fieldEntry, fieldEntry.getDesc());
    }

    private void indexFieldTypeDescriptor(FieldDefEntry field, TypeDescriptor typeDescriptor) {
        if (typeDescriptor.isType()) {
            ClassEntry referencedClass = typeDescriptor.getTypeEntry();
            this.fieldTypeReferences.put((Object)referencedClass, new EntryReference<ClassEntry, FieldDefEntry>(referencedClass, referencedClass.getName(), field));
        } else if (typeDescriptor.isArray()) {
            this.indexFieldTypeDescriptor(field, typeDescriptor.getArrayType());
        }
    }

    @Override
    public void indexMethodReference(MethodDefEntry callerEntry, MethodEntry referencedEntry, ReferenceTargetType targetType) {
        this.referencesToMethods.put((Object)referencedEntry, new EntryReference<MethodEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry, targetType));
        this.methodReferences.put((Object)callerEntry, (Object)referencedEntry);
        if (referencedEntry.isConstructor()) {
            ClassEntry referencedClass = (ClassEntry)referencedEntry.getParent();
            this.referencesToClasses.put((Object)referencedClass, new EntryReference<ClassEntry, MethodDefEntry>(referencedClass, referencedEntry.getName(), callerEntry, targetType));
        }
    }

    @Override
    public void indexFieldReference(MethodDefEntry callerEntry, FieldEntry referencedEntry, ReferenceTargetType targetType) {
        this.referencesToFields.put((Object)referencedEntry, new EntryReference<FieldEntry, MethodDefEntry>(referencedEntry, referencedEntry.getName(), callerEntry, targetType));
    }

    @Override
    public void indexLambda(MethodDefEntry callerEntry, Lambda lambda, ReferenceTargetType targetType) {
        if (lambda.getImplMethod() instanceof MethodEntry) {
            this.indexMethodReference(callerEntry, (MethodEntry)lambda.getImplMethod(), targetType);
        } else {
            this.indexFieldReference(callerEntry, (FieldEntry)lambda.getImplMethod(), targetType);
        }
        this.indexMethodDescriptor(callerEntry, lambda.getInvokedType());
        this.indexMethodDescriptor(callerEntry, lambda.getSamMethodType());
        this.indexMethodDescriptor(callerEntry, lambda.getInstantiatedMethodType());
    }

    @Override
    public void processIndex(JarIndex index) {
        this.methodReferences = this.remapReferences(index, this.methodReferences);
        this.referencesToMethods = this.remapReferencesTo(index, this.referencesToMethods);
        this.referencesToClasses = this.remapReferencesTo(index, this.referencesToClasses);
        this.referencesToFields = this.remapReferencesTo(index, this.referencesToFields);
        this.fieldTypeReferences = this.remapReferencesTo(index, this.fieldTypeReferences);
        this.methodTypeReferences = this.remapReferencesTo(index, this.methodTypeReferences);
    }

    private <K extends Entry<?>, V extends Entry<?>> Multimap<K, V> remapReferences(JarIndex index, Multimap<K, V> multimap) {
        int keySetSize = multimap.keySet().size();
        HashMultimap resolved = HashMultimap.create((int)multimap.keySet().size(), (int)(keySetSize == 0 ? 0 : multimap.size() / keySetSize));
        for (Map.Entry entry : multimap.entries()) {
            resolved.put((Object)this.remap(index, (Entry)entry.getKey()), (Object)this.remap(index, (Entry)entry.getValue()));
        }
        return resolved;
    }

    private <E extends Entry<?>, C extends Entry<?>> Multimap<E, EntryReference<E, C>> remapReferencesTo(JarIndex index, Multimap<E, EntryReference<E, C>> multimap) {
        int keySetSize;
        HashMultimap resolved = HashMultimap.create((int)keySetSize, (int)((keySetSize = multimap.keySet().size()) == 0 ? 0 : multimap.size() / keySetSize));
        for (Map.Entry entry : multimap.entries()) {
            resolved.put((Object)this.remap(index, (Entry)entry.getKey()), this.remap(index, (EntryReference)entry.getValue()));
        }
        return resolved;
    }

    private <E extends Entry<?>> E remap(JarIndex index, E entry) {
        return index.getEntryResolver().resolveFirstEntry(entry, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    private <E extends Entry<?>, C extends Entry<?>> EntryReference<E, C> remap(JarIndex index, EntryReference<E, C> reference) {
        return index.getEntryResolver().resolveFirstReference(reference, ResolutionStrategy.RESOLVE_CLOSEST);
    }

    public Collection<MethodEntry> getMethodsReferencedBy(MethodEntry entry) {
        return this.methodReferences.get((Object)entry);
    }

    public Collection<EntryReference<FieldEntry, MethodDefEntry>> getReferencesToField(FieldEntry entry) {
        return this.referencesToFields.get((Object)entry);
    }

    public Collection<EntryReference<ClassEntry, MethodDefEntry>> getReferencesToClass(ClassEntry entry) {
        return this.referencesToClasses.get((Object)entry);
    }

    public Collection<EntryReference<MethodEntry, MethodDefEntry>> getReferencesToMethod(MethodEntry entry) {
        return this.referencesToMethods.get((Object)entry);
    }

    public Collection<EntryReference<ClassEntry, FieldDefEntry>> getFieldTypeReferencesToClass(ClassEntry entry) {
        return this.fieldTypeReferences.get((Object)entry);
    }

    public Collection<EntryReference<ClassEntry, MethodDefEntry>> getMethodTypeReferencesToClass(ClassEntry entry) {
        return this.methodTypeReferences.get((Object)entry);
    }
}

