/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils.validation;

import cuchaz.enigma.utils.validation.Message;
import cuchaz.enigma.utils.validation.ParameterizedMessage;
import cuchaz.enigma.utils.validation.Validatable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public class ValidationContext {
    private Validatable activeElement = null;
    private final Set<Validatable> elements = new HashSet<Validatable>();
    private final List<ParameterizedMessage> messages = new ArrayList<ParameterizedMessage>();

    public void setActiveElement(@Nullable Validatable v) {
        if (v != null) {
            this.elements.add(v);
        }
        this.activeElement = v;
    }

    public void raise(Message message, Object ... args) {
        ParameterizedMessage pm = new ParameterizedMessage(message, args);
        if (this.activeElement != null) {
            this.activeElement.addMessage(pm);
        }
        this.messages.add(pm);
    }

    public boolean canProceed() {
        return this.messages.stream().noneMatch(m -> m.message.type == Message.Type.ERROR);
    }

    public List<ParameterizedMessage> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void reset() {
        this.activeElement = null;
        this.elements.forEach(Validatable::clearMessages);
        this.elements.clear();
        this.messages.clear();
    }
}

