/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.translation.TranslateResult;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.entry.Entry;
import javax.annotation.Nullable;

public abstract class ParentedEntry<P extends Entry<?>>
implements Entry<P> {
    protected final P parent;
    protected final String name;
    @Nullable
    protected final String javadocs;

    protected ParentedEntry(P parent, String name, String javadocs) {
        this.parent = parent;
        this.name = name;
        this.javadocs = javadocs;
        Preconditions.checkNotNull((Object)name, (Object)"Name cannot be null");
    }

    @Override
    public abstract ParentedEntry<P> withParent(P var1);

    @Override
    public abstract ParentedEntry<P> withName(String var1);

    protected abstract TranslateResult<? extends ParentedEntry<P>> extendedTranslate(Translator var1, @Nullable EntryMapping var2);

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public P getParent() {
        return this.parent;
    }

    @Override
    @Nullable
    public String getJavadocs() {
        return this.javadocs;
    }

    public TranslateResult<? extends ParentedEntry<P>> extendedTranslate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        P parent = this.getParent();
        EntryMapping mapping = this.resolveMapping(resolver, mappings);
        if (parent == null) {
            return this.extendedTranslate(translator, mapping);
        }
        Entry translatedParent = (Entry)translator.translate(parent);
        return ((ParentedEntry)this.withParent(translatedParent)).extendedTranslate(translator, mapping);
    }

    private EntryMapping resolveMapping(EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        for (ParentedEntry entry : resolver.resolveEntry(this, ResolutionStrategy.RESOLVE_ROOT)) {
            EntryMapping mapping = mappings.get(entry);
            if (mapping == null) continue;
            return mapping;
        }
        return null;
    }
}

