/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.TranslateResult;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public interface Translator {
    @Nullable
    public <T extends Translatable> TranslateResult<T> extendedTranslate(@Nullable T var1);

    @Deprecated
    @Nullable
    default public <T extends Translatable> T translate(@Nullable T translatable) {
        TranslateResult<T> res = this.extendedTranslate(translatable);
        return res == null ? null : (T)res.getValue();
    }

    default public <T extends Translatable> Collection<T> translate(Collection<T> translatable) {
        return translatable.stream().map(this::translate).collect(Collectors.toList());
    }

    default public <T extends Translatable> Set<T> translate(Set<T> translatable) {
        return translatable.stream().map(this::translate).collect(Collectors.toSet());
    }

    default public <T extends Translatable, V> Map<T, V> translateKeys(Map<T, V> translatable) {
        HashMap<Translatable, V> result = new HashMap<Translatable, V>(translatable.size());
        for (Map.Entry<T, V> entry : translatable.entrySet()) {
            result.put(this.translate((Translatable)entry.getKey()), entry.getValue());
        }
        return result;
    }

    default public <K extends Translatable, V extends Translatable> Map<K, V> translate(Map<K, V> translatable) {
        HashMap<Translatable, Translatable> result = new HashMap<Translatable, Translatable>(translatable.size());
        for (Map.Entry<K, V> entry : translatable.entrySet()) {
            result.put(this.translate((Translatable)entry.getKey()), this.translate((Translatable)entry.getValue()));
        }
        return result;
    }

    default public <K extends Translatable, V extends Translatable> Multimap<K, V> translate(Multimap<K, V> translatable) {
        HashMultimap result = HashMultimap.create((int)translatable.size(), (int)1);
        for (Map.Entry entry : translatable.asMap().entrySet()) {
            result.putAll((Object)this.translate((Translatable)entry.getKey()), this.translate((Collection)entry.getValue()));
        }
        return result;
    }
}

