/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.EnigmaServices;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.source.RenamableTokenType;
import cuchaz.enigma.source.SourceIndex;
import cuchaz.enigma.source.SourceRemapper;
import cuchaz.enigma.source.Token;
import cuchaz.enigma.translation.LocalNameGenerator;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.ResolutionStrategy;
import cuchaz.enigma.translation.representation.TypeDescriptor;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableDefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;

public class DecompiledClassSource {
    private final ClassEntry classEntry;
    private final SourceIndex obfuscatedIndex;
    private SourceIndex remappedIndex;
    private final Map<RenamableTokenType, Collection<Token>> highlightedTokens = new EnumMap<RenamableTokenType, Collection<Token>>(RenamableTokenType.class);

    public DecompiledClassSource(ClassEntry classEntry, SourceIndex index) {
        this.classEntry = classEntry;
        this.obfuscatedIndex = index;
        this.remappedIndex = index;
    }

    public static DecompiledClassSource text(ClassEntry classEntry, String text) {
        return new DecompiledClassSource(classEntry, new SourceIndex(text));
    }

    public void remapSource(EnigmaProject project, Translator translator) {
        this.highlightedTokens.clear();
        SourceRemapper remapper = new SourceRemapper(this.obfuscatedIndex.getSource(), this.obfuscatedIndex.referenceTokens());
        SourceRemapper.Result remapResult = remapper.remap((token, movedToken) -> this.remapToken(project, token, movedToken, translator));
        this.remappedIndex = this.obfuscatedIndex.remapTo(remapResult);
    }

    private String remapToken(EnigmaProject project, Token token, Token movedToken, Translator translator) {
        String defaultName;
        EntryReference<Entry<?>, Entry<?>> reference = this.obfuscatedIndex.getReference(token);
        Entry<?> entry = reference.getNameableEntry();
        Entry<?> translatedEntry = translator.translate(entry);
        if (project.isRenamable(reference)) {
            if (project.getMapper().hasDeobfMapping(entry)) {
                this.highlightToken(movedToken, RenamableTokenType.DEOBFUSCATED);
                return translatedEntry.getSourceRemapName();
            }
            Optional<String> proposedName = this.proposeName(project, entry);
            if (proposedName.isPresent()) {
                this.highlightToken(movedToken, RenamableTokenType.PROPOSED);
                return proposedName.get();
            }
            this.highlightToken(movedToken, RenamableTokenType.OBFUSCATED);
        }
        if ((defaultName = this.generateDefaultName(translatedEntry)) != null) {
            return defaultName;
        }
        return null;
    }

    private Optional<String> proposeName(EnigmaProject project, Entry<?> entry) {
        EnigmaServices services = project.getEnigma().getServices();
        return services.get(NameProposalService.TYPE).stream().flatMap(nameProposalService -> {
            EntryRemapper mapper = project.getMapper();
            Collection<Entry> resolved = mapper.getObfResolver().resolveEntry(entry, ResolutionStrategy.RESOLVE_ROOT);
            return resolved.stream().map(e -> nameProposalService.proposeName((Entry<?>)e, mapper)).filter(Optional::isPresent).map(Optional::get);
        }).findFirst();
    }

    @Nullable
    private String generateDefaultName(Entry<?> entry) {
        if (entry instanceof LocalVariableDefEntry) {
            LocalVariableDefEntry localVariable = (LocalVariableDefEntry)entry;
            int index = localVariable.getIndex();
            if (localVariable.isArgument()) {
                List<TypeDescriptor> arguments = ((MethodEntry)localVariable.getParent()).getDesc().getArgumentDescs();
                return LocalNameGenerator.generateArgumentName(index, localVariable.getDesc(), arguments);
            }
            return LocalNameGenerator.generateLocalVariableName(index, localVariable.getDesc());
        }
        return null;
    }

    public ClassEntry getEntry() {
        return this.classEntry;
    }

    public SourceIndex getIndex() {
        return this.remappedIndex;
    }

    public Map<RenamableTokenType, Collection<Token>> getHighlightedTokens() {
        return this.highlightedTokens;
    }

    private void highlightToken(Token token, RenamableTokenType highlightType) {
        this.highlightedTokens.computeIfAbsent(highlightType, t -> new ArrayList()).add(token);
    }

    public int getObfuscatedOffset(int deobfOffset) {
        return DecompiledClassSource.getOffset(this.remappedIndex, this.obfuscatedIndex, deobfOffset);
    }

    public int getDeobfuscatedOffset(int obfOffset) {
        return DecompiledClassSource.getOffset(this.obfuscatedIndex, this.remappedIndex, obfOffset);
    }

    private static int getOffset(SourceIndex fromIndex, SourceIndex toIndex, int fromOffset) {
        int relativeOffset = 0;
        Iterator<Token> fromTokenItr = fromIndex.referenceTokens().iterator();
        Iterator<Token> toTokenItr = toIndex.referenceTokens().iterator();
        while (fromTokenItr.hasNext() && toTokenItr.hasNext()) {
            Token fromToken = fromTokenItr.next();
            Token toToken = toTokenItr.next();
            if (fromToken.end > fromOffset) break;
            relativeOffset = toToken.end - fromToken.end;
        }
        return fromOffset + relativeOffset;
    }

    public String toString() {
        return this.remappedIndex.getSource();
    }
}

