/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.panels;

import cuchaz.enigma.EnigmaProject;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.config.Config;
import cuchaz.enigma.gui.BrowserCaret;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import java.awt.Color;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;

public class PanelEditor
extends JEditorPane {
    private boolean mouseIsPressed = false;
    public int fontSize = 12;

    public PanelEditor(final Gui gui) {
        this.setEditable(false);
        this.setSelectionColor(new Color(31, 46, 90));
        this.setCaret(new BrowserCaret());
        this.setFont(ScaleUtil.getFont(this.getFont().getFontName(), 0, this.fontSize));
        this.addCaretListener(event -> gui.onCaretMove(event.getDot(), this.mouseIsPressed));
        final PanelEditor self = this;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                PanelEditor.this.mouseIsPressed = true;
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                switch (e.getButton()) {
                    case 3: {
                        self.setCaretPosition(self.viewToModel(e.getPoint()));
                        break;
                    }
                    case 4: {
                        gui.getController().openPreviousReference();
                        break;
                    }
                    case 5: {
                        gui.getController().openNextReference();
                    }
                }
                PanelEditor.this.mouseIsPressed = false;
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                if (event.isControlDown()) {
                    gui.setShouldNavigateOnClick(false);
                    switch (event.getKeyCode()) {
                        case 73: {
                            gui.popupMenu.showInheritanceMenu.doClick();
                            break;
                        }
                        case 77: {
                            gui.popupMenu.showImplementationsMenu.doClick();
                            break;
                        }
                        case 78: {
                            gui.popupMenu.openEntryMenu.doClick();
                            break;
                        }
                        case 80: {
                            gui.popupMenu.openPreviousMenu.doClick();
                            break;
                        }
                        case 69: {
                            gui.popupMenu.openNextMenu.doClick();
                            break;
                        }
                        case 67: {
                            if (event.isShiftDown()) {
                                gui.popupMenu.showCallsSpecificMenu.doClick();
                                break;
                            }
                            gui.popupMenu.showCallsMenu.doClick();
                            break;
                        }
                        case 79: {
                            gui.popupMenu.toggleMappingMenu.doClick();
                            break;
                        }
                        case 82: {
                            gui.popupMenu.renameMenu.doClick();
                            break;
                        }
                        case 68: {
                            gui.popupMenu.editJavadocMenu.doClick();
                            break;
                        }
                        case 116: {
                            gui.getController().refreshCurrentClass();
                            break;
                        }
                        case 70: {
                            break;
                        }
                        case 61: 
                        case 107: 
                        case 521: {
                            self.offsetEditorZoom(2);
                            break;
                        }
                        case 45: 
                        case 109: {
                            self.offsetEditorZoom(-2);
                            break;
                        }
                        default: {
                            gui.setShouldNavigateOnClick(true);
                        }
                    }
                }
            }

            @Override
            public void keyTyped(KeyEvent event) {
                if (!gui.popupMenu.renameMenu.isEnabled()) {
                    return;
                }
                if (!event.isControlDown() && !event.isAltDown() && Character.isJavaIdentifierPart(event.getKeyChar())) {
                    String packageName;
                    EnigmaProject project = gui.getController().project;
                    EntryReference<Entry<?>, Entry<?>> reference = project.getMapper().deobfuscate(gui.cursorReference);
                    Entry<?> entry = reference.getNameableEntry();
                    String name = String.valueOf(event.getKeyChar());
                    if (entry instanceof ClassEntry && ((ClassEntry)entry).getParent() == null && (packageName = ((ClassEntry)entry).getPackageName()) != null) {
                        name = packageName + "/" + name;
                    }
                    gui.popupMenu.renameMenu.doClick();
                    gui.renameTextField.setText(name);
                }
            }

            @Override
            public void keyReleased(KeyEvent event) {
                gui.setShouldNavigateOnClick(event.isControlDown());
            }
        });
    }

    public void offsetEditorZoom(int zoomAmount) {
        int newResult = this.fontSize + zoomAmount;
        if (newResult > 8 && newResult < 72) {
            this.fontSize = newResult;
            this.setFont(ScaleUtil.getFont(this.getFont().getFontName(), 0, this.fontSize));
        }
    }

    public void resetEditorZoom() {
        this.fontSize = 12;
        this.setFont(ScaleUtil.getFont(this.getFont().getFontName(), 0, this.fontSize));
    }

    @Override
    public Color getCaretColor() {
        return new Color(Config.getInstance().caretColor);
    }
}

