/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import de.sciss.syntaxpane.actions.DocumentSearchData;
import de.sciss.syntaxpane.actions.gui.QuickFindDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class EnigmaQuickFindDialog
extends QuickFindDialog {
    public EnigmaQuickFindDialog(JTextComponent target) {
        super(target, DocumentSearchData.getFromEditor((JTextComponent)target));
        JToolBar toolBar = this.getToolBar();
        JTextField textField = this.getTextField(toolBar);
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                if (e.getKeyCode() == 10) {
                    JToolBar toolBar = EnigmaQuickFindDialog.this.getToolBar();
                    boolean next = !e.isShiftDown();
                    JButton button = next ? EnigmaQuickFindDialog.this.getNextButton(toolBar) : EnigmaQuickFindDialog.this.getPrevButton(toolBar);
                    button.doClick();
                }
            }
        });
    }

    public void showFor(JTextComponent target) {
        String selectedText = target.getSelectedText();
        try {
            super.showFor(target);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        Container view = target.getParent();
        Point loc = new Point(0, view.getHeight() - this.getSize().height);
        this.setLocationRelativeTo(view);
        SwingUtilities.convertPointToScreen(loc, view);
        this.setLocation(loc);
        JToolBar toolBar = this.getToolBar();
        JTextField textField = this.getTextField(toolBar);
        if (selectedText != null) {
            textField.setText(selectedText);
        }
        textField.selectAll();
    }

    private JToolBar getToolBar() {
        return EnigmaQuickFindDialog.components(this.getContentPane(), JToolBar.class).findFirst().orElse(null);
    }

    private JTextField getTextField(JToolBar toolBar) {
        return EnigmaQuickFindDialog.components(toolBar, JTextField.class).findFirst().orElse(null);
    }

    private JButton getNextButton(JToolBar toolBar) {
        Stream<JButton> buttons = EnigmaQuickFindDialog.components(toolBar, JButton.class);
        return buttons.skip(1L).findFirst().orElse(null);
    }

    private JButton getPrevButton(JToolBar toolBar) {
        Stream<JButton> buttons = EnigmaQuickFindDialog.components(toolBar, JButton.class);
        return buttons.findFirst().orElse(null);
    }

    private static Stream<Component> components(Container container) {
        return IntStream.range(0, container.getComponentCount()).mapToObj(container::getComponent);
    }

    private static <T extends Component> Stream<T> components(Container container, Class<T> type) {
        return EnigmaQuickFindDialog.components(container).filter(type::isInstance).map(type::cast);
    }
}

