/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import cuchaz.enigma.command.CheckMappingsCommand;
import cuchaz.enigma.command.Command;
import cuchaz.enigma.command.ComposeMappingsCommand;
import cuchaz.enigma.command.ConvertMappingsCommand;
import cuchaz.enigma.command.DecompileCommand;
import cuchaz.enigma.command.DeobfuscateCommand;
import cuchaz.enigma.command.InvertMappingsCommand;
import cuchaz.enigma.command.MapSpecializedMethodsCommand;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class CommandMain {
    private static final Map<String, Command> COMMANDS = new LinkedHashMap<String, Command>();

    public static void main(String ... args) throws Exception {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("Requires a command");
            }
            String command = args[0].toLowerCase(Locale.ROOT);
            Command cmd = COMMANDS.get(command);
            if (cmd == null) {
                throw new IllegalArgumentException("Command not recognized: " + command);
            }
            if (!cmd.isValidArgument(args.length - 1)) {
                throw new CommandHelpException(cmd);
            }
            String[] cmdArgs = new String[args.length - 1];
            System.arraycopy(args, 1, cmdArgs, 0, args.length - 1);
            try {
                cmd.run(cmdArgs);
            }
            catch (Exception ex) {
                throw new CommandHelpException(cmd, (Throwable)ex);
            }
        }
        catch (CommandHelpException ex) {
            System.err.println(ex.getMessage());
            System.out.println(String.format("%s - %s", "Enigma", "0.15.3+build.170/Fabric"));
            System.out.println("Command " + ex.command.name + " has encountered an error! Usage:");
            CommandMain.printHelp(ex.command);
            System.exit(1);
        }
        catch (IllegalArgumentException ex) {
            System.err.println(ex.getMessage());
            CommandMain.printHelp();
            System.exit(1);
        }
    }

    private static void printHelp() {
        System.out.println(String.format("%s - %s", "Enigma", "0.15.3+build.170/Fabric"));
        System.out.println("Usage:");
        System.out.println("\tjava -cp enigma.jar cuchaz.enigma.CommandMain <command>");
        System.out.println("\twhere <command> is one of:");
        for (Command command : COMMANDS.values()) {
            CommandMain.printHelp(command);
        }
    }

    private static void printHelp(Command command) {
        System.out.println("\t\t" + command.name + " " + command.getUsage());
    }

    private static void register(Command command) {
        Command old = COMMANDS.put(command.name, command);
        if (old != null) {
            System.err.println("Command " + old + " with name " + command.name + " has been substituted by " + command);
        }
    }

    static {
        CommandMain.register(new DeobfuscateCommand());
        CommandMain.register(new DecompileCommand());
        CommandMain.register(new ConvertMappingsCommand());
        CommandMain.register(new ComposeMappingsCommand());
        CommandMain.register(new InvertMappingsCommand());
        CommandMain.register(new CheckMappingsCommand());
        CommandMain.register(new MapSpecializedMethodsCommand());
    }

    private static final class CommandHelpException
    extends IllegalArgumentException {
        final Command command;

        CommandHelpException(Command command) {
            this.command = command;
        }

        CommandHelpException(Command command, Throwable cause) {
            super(cause);
            this.command = command;
        }
    }
}

