/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils.search;

import cuchaz.enigma.utils.Pair;
import cuchaz.enigma.utils.search.SearchEntry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SearchUtil<T extends SearchEntry> {
    private final Map<T, Entry<T>> entries = new HashMap<T, Entry<T>>();
    private final Map<String, Integer> hitCount = new HashMap<String, Integer>();

    public void add(T entry) {
        Entry<T> e = Entry.from(entry);
        this.entries.put(entry, e);
    }

    public void add(Entry<T> entry) {
        this.entries.put(entry.searchEntry, entry);
    }

    public void addAll(Collection<T> entries) {
        this.entries.putAll(entries.parallelStream().collect(Collectors.toMap(e -> e, Entry::from)));
    }

    public void remove(T entry) {
        this.entries.remove(entry);
    }

    public void clear() {
        this.entries.clear();
    }

    public void clearHits() {
        this.hitCount.clear();
    }

    public Stream<T> search(String term) {
        return (Stream)this.entries.values().parallelStream().map(e -> new Pair<Entry, Float>((Entry)e, Float.valueOf(e.getScore(term, this.hitCount.getOrDefault(e.searchEntry.getIdentifier(), 0))))).filter(e -> ((Float)e.b).floatValue() > 0.0f).sorted(Comparator.comparingDouble(o -> -((Float)o.b).floatValue())).map(e -> ((Entry)e.a).searchEntry).sequential();
    }

    public void hit(T entry) {
        if (this.entries.containsKey(entry)) {
            this.hitCount.compute(entry.getIdentifier(), (_id, i) -> i == null ? 1 : i + 1);
        }
    }

    public static final class Entry<T extends SearchEntry> {
        public final T searchEntry;
        private final String[][] components;

        private Entry(T searchEntry, String[][] components) {
            this.searchEntry = searchEntry;
            this.components = components;
        }

        public float getScore(String term, int hits) {
            String ucTerm = term.toUpperCase(Locale.ROOT);
            float maxScore = (float)Arrays.stream(this.components).mapToDouble(name -> Entry.getScoreFor(ucTerm, name)).max().orElse(0.0);
            return maxScore * (float)(hits + 1);
        }

        private static float getScoreFor(String term, String[] name) {
            int totalLength = Arrays.stream(name).mapToInt(String::length).sum();
            float scorePerChar = 1.0f / (float)totalLength;
            HashMap<String, Float> snapshots = new HashMap<String, Float>();
            snapshots.put(term, Float.valueOf(0.0f));
            for (int componentIndex = 0; componentIndex < name.length; ++componentIndex) {
                String component = name[componentIndex];
                float posMultiplier = (float)(name.length - componentIndex) * 0.3f;
                HashMap newSnapshots = new HashMap();
                for (Map.Entry snapshot : snapshots.entrySet()) {
                    String remaining = (String)snapshot.getKey();
                    float score = ((Float)snapshot.getValue()).floatValue();
                    component = component.toUpperCase(Locale.ROOT);
                    int l = Entry.compareEqualLength(remaining, component);
                    for (int i = 1; i <= l; ++i) {
                        float baseScore = scorePerChar * (float)i;
                        float chainBonus = (float)(i - 1) * 0.5f;
                        Entry.merge(newSnapshots, Collections.singletonMap(remaining.substring(i), Float.valueOf(score + baseScore * posMultiplier + chainBonus)), Math::max);
                    }
                }
                Entry.merge(snapshots, newSnapshots, Math::max);
            }
            return snapshots.getOrDefault("", Float.valueOf(0.0f)).floatValue();
        }

        private static <K, V> void merge(Map<K, V> self, Map<K, V> source, BiFunction<V, V, V> combiner) {
            source.forEach((k, v) -> self.compute(k, (_k, v1) -> v1 == null ? v : (v == null ? v1 : combiner.apply(v, v1))));
        }

        public static <T extends SearchEntry> Entry<T> from(T e) {
            String[][] components = (String[][])e.getSearchableNames().parallelStream().map(Entry::wordwiseSplit).toArray(x$0 -> new String[x$0][]);
            return new Entry<T>(e, components);
        }

        private static int compareEqualLength(String s1, String s2) {
            int len;
            for (len = 0; len < s1.length() && len < s2.length() && s1.charAt(len) == s2.charAt(len); ++len) {
            }
            return len;
        }

        private static String[] wordwiseSplit(String input) {
            ArrayList<String> list = new ArrayList<String>();
            while (!input.isEmpty()) {
                int take;
                if (Character.isLetter(input.charAt(0))) {
                    if (input.length() == 1) {
                        take = 1;
                    } else {
                        boolean nextSegmentIsUppercase;
                        boolean bl = nextSegmentIsUppercase = Character.isUpperCase(input.charAt(0)) && Character.isUpperCase(input.charAt(1));
                        if (nextSegmentIsUppercase) {
                            int nextLowercase = 1;
                            while (Character.isUpperCase(input.charAt(nextLowercase))) {
                                if (++nextLowercase != input.length()) continue;
                                ++nextLowercase;
                                break;
                            }
                            take = nextLowercase - 1;
                        } else {
                            int nextUppercase;
                            for (nextUppercase = 1; nextUppercase < input.length() && Character.isLowerCase(input.charAt(nextUppercase)); ++nextUppercase) {
                            }
                            take = nextUppercase;
                        }
                    }
                } else if (Character.isDigit(input.charAt(0))) {
                    int nextNonNum;
                    for (nextNonNum = 1; nextNonNum < input.length() && Character.isLetter(input.charAt(nextNonNum)) && !Character.isLowerCase(input.charAt(nextNonNum)); ++nextNonNum) {
                    }
                    take = nextNonNum;
                } else {
                    take = 1;
                }
                list.add(input.substring(0, take));
                input = input.substring(take);
            }
            return list.toArray(new String[0]);
        }
    }
}

