/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class SignatureUpdater {
    public static String update(String signature, ClassNameUpdater updater) {
        try {
            int i;
            StringBuilder buf = new StringBuilder();
            StringReader reader = new StringReader(signature);
            while ((i = reader.read()) != -1) {
                char c = (char)i;
                if (c == 'L') {
                    buf.append('L');
                    String className = SignatureUpdater.readClass(reader);
                    if (className == null) {
                        throw new IllegalArgumentException("Malformed signature: " + signature);
                    }
                    buf.append(updater.update(className));
                    buf.append(';');
                    continue;
                }
                buf.append(c);
            }
            return buf.toString();
        }
        catch (IOException ex) {
            throw new Error(ex);
        }
    }

    private static String readClass(StringReader reader) throws IOException {
        int i;
        StringBuilder buf = new StringBuilder();
        int depth = 0;
        while ((i = reader.read()) != -1) {
            char c = (char)i;
            if (c == '<') {
                ++depth;
                continue;
            }
            if (c == '>') {
                --depth;
                continue;
            }
            if (depth != 0) continue;
            if (c == ';') {
                return buf.toString();
            }
            buf.append(c);
        }
        return null;
    }

    public static List<String> getClasses(String signature) {
        ArrayList classNames = Lists.newArrayList();
        SignatureUpdater.update(signature, className -> {
            classNames.add(className);
            return className;
        });
        return classNames;
    }

    public static interface ClassNameUpdater {
        public String update(String var1);
    }
}

