/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.analysis;

import com.google.common.collect.Lists;
import cuchaz.enigma.analysis.index.InheritanceIndex;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.tree.DefaultMutableTreeNode;

public class ClassImplementationsTreeNode
extends DefaultMutableTreeNode {
    private final Translator translator;
    private final ClassEntry entry;

    public ClassImplementationsTreeNode(Translator translator, ClassEntry entry) {
        this.translator = translator;
        this.entry = entry;
    }

    public static ClassImplementationsTreeNode findNode(ClassImplementationsTreeNode node, MethodEntry entry) {
        if (node.entry.equals((ClassEntry)entry.getParent())) {
            return node;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassImplementationsTreeNode foundNode = ClassImplementationsTreeNode.findNode((ClassImplementationsTreeNode)node.getChildAt(i), entry);
            if (foundNode == null) continue;
            return foundNode;
        }
        return null;
    }

    public ClassEntry getClassEntry() {
        return this.entry;
    }

    @Override
    public String toString() {
        return this.translator.translate(this.entry).toString();
    }

    public void load(JarIndex index) {
        ArrayList nodes = Lists.newArrayList();
        InheritanceIndex inheritanceIndex = index.getInheritanceIndex();
        Collection<ClassEntry> inheritors = inheritanceIndex.getChildren(this.entry);
        for (ClassEntry inheritor : inheritors) {
            nodes.add(new ClassImplementationsTreeNode(this.translator, inheritor));
        }
        nodes.forEach(this::add);
    }
}

