/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.lexers;

import de.sciss.syntaxpane.Lexer;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.TokenComparators;
import de.sciss.syntaxpane.TokenType;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Segment;

public class SimpleRegexLexer
implements Lexer {
    Map<TokenType, Pattern> patterns = new HashMap<TokenType, Pattern>();

    public SimpleRegexLexer(Map props) {
        this.putPatterns(props);
    }

    public SimpleRegexLexer(String propsLocation) throws IOException {
        Properties props = new Properties();
        props.load(new FileReader(propsLocation));
        this.putPatterns(props);
    }

    @Override
    public void parse(Segment segment, int ofst, List<Token> tokens) {
        TreeSet<Token> allMatches = new TreeSet<Token>(TokenComparators.LONGEST_FIRST);
        for (Map.Entry<TokenType, Pattern> e : this.patterns.entrySet()) {
            Matcher m3 = e.getValue().matcher(segment);
            while (m3.find()) {
                Token t = new Token(e.getKey(), m3.start() + ofst, m3.end() - m3.start());
                allMatches.add(t);
            }
        }
        int end = -1;
        for (Token t : allMatches) {
            if (t.start <= end) continue;
            tokens.add(t);
            end = t.end();
        }
    }

    public SimpleRegexLexer putPattern(TokenType type, String regex) {
        this.patterns.put(type, Pattern.compile(regex));
        return this;
    }

    public SimpleRegexLexer putPatterns(Map props) {
        for (Object key : props.keySet()) {
            TokenType t = TokenType.valueOf(key.toString());
            this.patterns.put(t, Pattern.compile(props.get(key).toString()));
        }
        return this;
    }
}

