/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.utils;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.reflect.ClassPath;
import com.google.gson.Gson;
import cuchaz.enigma.config.Config;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;

public class I18n {
    public static final String DEFAULT_LANGUAGE = "en_us";
    private static final Gson GSON = new Gson();
    private static Map<String, String> translations = Maps.newHashMap();
    private static Map<String, String> defaultTranslations = Maps.newHashMap();
    private static Map<String, String> languageNames = Maps.newHashMap();

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> load(String language) {
        block30: {
            try {
                Throwable throwable = null;
                try (InputStream inputStream = I18n.class.getResourceAsStream("/lang/" + language + ".json");){
                    if (inputStream != null) {
                        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            Map map = GSON.fromJson((Reader)reader, Map.class);
                            return map;
                        }
                    }
                    break block30;
                    {
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            throw throwable3;
                        }
                    }
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Collections.emptyMap();
    }

    public static String translate(String key) {
        String value = translations.get(key);
        if (value != null) {
            return value;
        }
        value = defaultTranslations.get(key);
        if (value != null) {
            return value;
        }
        return key;
    }

    public static String getLanguageName(String language) {
        return languageNames.get(language);
    }

    public static void setLanguage(String language) {
        Config.getInstance().language = language;
        try {
            Config.getInstance().saveConfig();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ArrayList<String> getAvailableLanguages() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ImmutableList<ClassPath.ResourceInfo> resources = ClassPath.from(Thread.currentThread().getContextClassLoader()).getResources().asList();
            Stream dirStream = resources.stream();
            dirStream.forEach(context -> {
                String file = context.getResourceName();
                if (file.startsWith("lang/") && file.endsWith(".json")) {
                    String fileName = file.substring(5, file.length() - 5);
                    list.add(fileName);
                    I18n.loadLanguageName(fileName);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void loadLanguageName(String fileName) {
        try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("lang/" + fileName + ".json");
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            Map map = GSON.fromJson((Reader)reader, Map.class);
            languageNames.put(fileName, map.get("language").toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        translations = I18n.load(Config.getInstance().language);
        defaultTranslations = I18n.load(DEFAULT_LANGUAGE);
    }
}

