/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.gui.util.ScaleUtil;
import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.util.concurrent.CompletableFuture;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDialog
implements ProgressListener,
AutoCloseable {
    private JFrame frame = new JFrame(String.format(I18n.translate("progress.operation"), "Enigma"));
    private JLabel labelTitle;
    private JLabel labelText;
    private JProgressBar progress;

    public ProgressDialog(JFrame parent) {
        Container pane = this.frame.getContentPane();
        FlowLayout layout = new FlowLayout();
        layout.setAlignment(0);
        pane.setLayout(layout);
        this.labelTitle = new JLabel();
        pane.add(this.labelTitle);
        JPanel panel = new JPanel();
        pane.add(panel);
        panel.setLayout(new BorderLayout());
        this.labelText = Utils.unboldLabel(new JLabel());
        this.progress = new JProgressBar();
        this.labelText.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        panel.add((Component)this.labelText, "North");
        panel.add((Component)this.progress, "Center");
        panel.setPreferredSize(ScaleUtil.getDimension(360, 50));
        pane.doLayout();
        this.frame.setSize(ScaleUtil.getDimension(400, 120));
        this.frame.setResizable(false);
        this.frame.setLocationRelativeTo(parent);
        this.frame.setVisible(true);
        this.frame.setDefaultCloseOperation(0);
    }

    public static CompletableFuture<Void> runOffThread(JFrame parent, ProgressRunnable runnable) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        new Thread(() -> {
            try (ProgressDialog progress = new ProgressDialog(parent);){
                runnable.run(progress);
                future.complete(null);
            }
            catch (Exception ex) {
                future.completeExceptionally(ex);
                throw new Error(ex);
            }
        }).start();
        return future;
    }

    @Override
    public void close() {
        this.frame.dispose();
    }

    @Override
    public void init(int totalWork, String title) {
        this.labelTitle.setText(title);
        this.progress.setMinimum(0);
        this.progress.setMaximum(totalWork);
        this.progress.setValue(0);
    }

    @Override
    public void step(int numDone, String message) {
        this.labelText.setText(message);
        if (numDone != -1) {
            this.progress.setValue(numDone);
            this.progress.setIndeterminate(false);
        } else {
            this.progress.setIndeterminate(true);
        }
        this.frame.validate();
        this.frame.repaint();
    }

    public static interface ProgressRunnable {
        public void run(ProgressListener var1) throws Exception;
    }
}

