/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.annotations.Nullable;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.MemberReference;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MethodBody;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.CollectionUtilities;
import com.strobel.core.VerifyArgument;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AssignmentExpression;
import com.strobel.decompiler.languages.java.ast.AssignmentOperatorType;
import com.strobel.decompiler.languages.java.ast.AstBuilder;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstType;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorExpression;
import com.strobel.decompiler.languages.java.ast.BinaryOperatorType;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.CatchClause;
import com.strobel.decompiler.languages.java.ast.ClassOfExpression;
import com.strobel.decompiler.languages.java.ast.ConditionalExpression;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.FieldDeclaration;
import com.strobel.decompiler.languages.java.ast.InvocationExpression;
import com.strobel.decompiler.languages.java.ast.JavaModifierToken;
import com.strobel.decompiler.languages.java.ast.Keys;
import com.strobel.decompiler.languages.java.ast.MemberReferenceExpression;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.NullReferenceExpression;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.TryCatchStatement;
import com.strobel.decompiler.languages.java.ast.TypeDeclaration;
import com.strobel.decompiler.languages.java.ast.TypeReferenceExpression;
import com.strobel.decompiler.languages.java.ast.VariableDeclarationStatement;
import com.strobel.decompiler.languages.java.ast.transforms.IAstTransform;
import com.strobel.decompiler.patterns.AnyNode;
import com.strobel.decompiler.patterns.AstTypeMatch;
import com.strobel.decompiler.patterns.BackReference;
import com.strobel.decompiler.patterns.Choice;
import com.strobel.decompiler.patterns.IdentifierExpressionBackReference;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.NamedNode;
import com.strobel.decompiler.patterns.ParameterReferenceNode;
import com.strobel.decompiler.patterns.TypedLiteralNode;
import javax.lang.model.element.Modifier;

public class RewriteLegacyClassConstantsTransform
implements IAstTransform {
    private static final int CANDIDATE_MAX_CODE_SIZE = 32;
    private final DecompilerContext _context;

    public RewriteLegacyClassConstantsTransform(DecompilerContext context) {
        this._context = context;
    }

    @Override
    public void run(AstNode compilationUnit) {
        TypeDefinition currentType = this._context.getCurrentType();
        if (currentType.getCompilerTarget().hasClassLiterals()) {
            return;
        }
        MethodDefinition classMethod = this.tryLocateClassMethod(currentType, compilationUnit);
        if (classMethod != null && classMethod.getDeclaringType() != null) {
            new Rewriter(this._context, classMethod).run(compilationUnit);
        }
    }

    private MethodDefinition tryLocateClassMethod(TypeDefinition currentType, AstNode compilationUnit) {
        ClassMethodLocator locator = new ClassMethodLocator(this._context);
        locator.run(compilationUnit);
        if (locator.classMethod != null) {
            return locator.classMethod;
        }
        if (currentType.isNested()) {
            return this.tryLocateClassMethodOutOfScope(currentType);
        }
        return null;
    }

    @Nullable
    private MethodDefinition tryLocateClassMethodOutOfScope(TypeDefinition currentType) {
        TypeDefinition enclosingType = MetadataHelper.getOutermostEnclosingType(currentType);
        if (enclosingType == null) {
            return null;
        }
        AstBuilder builder = this._context.getUserData(Keys.AST_BUILDER);
        for (MethodDefinition m3 : enclosingType.getDeclaredMethods()) {
            MethodDeclaration method;
            MethodBody body;
            if (!ClassMethodLocator.isClassMethodCandidate(m3) || (body = m3.getBody()) == null || body.getCodeSize() > 32 || !ClassMethodLocator.PATTERN.matches(method = builder.createMethod(m3))) continue;
            return m3;
        }
        return null;
    }

    private static final class Rewriter
    extends ContextTrackingVisitor<Void> {
        private static final ConditionalExpression PATTERN = Rewriter.createPattern();
        private final MethodDefinition _method;
        private final MetadataParser _parser;

        protected Rewriter(DecompilerContext context, MethodDefinition classMethod) {
            super(context);
            this._method = VerifyArgument.notNull(classMethod, "classMethod");
            this._parser = new MetadataParser(classMethod.getDeclaringType());
        }

        @Override
        public Void visitConditionalExpression(ConditionalExpression node, Void data) {
            super.visitConditionalExpression(node, data);
            Match m3 = PATTERN.match(node);
            if (m3.success()) {
                MemberReference method;
                InvocationExpression call = (InvocationExpression)CollectionUtilities.firstOrDefault(m3.get("methodCall"));
                MemberReference memberReference = method = call != null ? call.getUserData(Keys.MEMBER_REFERENCE) : null;
                if (method == null || !method.isEquivalentTo(this._method)) {
                    return null;
                }
                PrimitiveExpression className = (PrimitiveExpression)CollectionUtilities.firstOrDefault(m3.get("class"));
                if (className != null && className.getValue() instanceof String) {
                    AstBuilder builder = this.context.getUserData(Keys.AST_BUILDER);
                    String dottedName = (String)className.getValue();
                    TypeReference classType = this._parser.parseTypeDescriptor(dottedName.replace('.', '/'));
                    ClassOfExpression replacement = new ClassOfExpression(call.getOffset(), builder.convertType(classType));
                    node.replaceWith(replacement);
                }
            }
            return null;
        }

        private static ConditionalExpression createPattern() {
            Expression target = new TypeReferenceExpression(new AnyNode().toType()).makeOptional().toExpression();
            MemberReferenceExpression access = new MemberReferenceExpression(target, "$any$", new AstType[0]);
            ConditionalExpression pattern = new ConditionalExpression(new BinaryOperatorExpression(access.withName("fieldAccess").toExpression(), BinaryOperatorType.EQUALITY, new NullReferenceExpression()), new AssignmentExpression(new BackReference("fieldAccess").toExpression(), AssignmentOperatorType.ASSIGN, target.clone().invoke("$any$", new TypedLiteralNode("class", String.class).toExpression()).withName("methodCall").toExpression()), new BackReference("fieldAccess").toExpression());
            return pattern;
        }
    }

    private static final class ClassMethodLocator
    extends ContextTrackingVisitor<Void> {
        static final MethodDeclaration PATTERN = ClassMethodLocator.createPattern();
        private TypeDeclaration _currentType;
        MethodDefinition classMethod;

        protected ClassMethodLocator(DecompilerContext context) {
            super(context);
        }

        @Override
        protected boolean shouldContinue() {
            return this.classMethod == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void visitTypeDeclaration(TypeDeclaration typeDeclaration, Void p) {
            if (this._currentType != null) {
                return null;
            }
            this._currentType = typeDeclaration;
            try {
                Void void_ = (Void)super.visitTypeDeclaration(typeDeclaration, p);
                return void_;
            }
            finally {
                this._currentType = null;
            }
        }

        @Override
        public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
            return null;
        }

        @Override
        public Void visitFieldDeclaration(FieldDeclaration node, Void data) {
            return null;
        }

        @Override
        protected Void visitChildren(AstNode node, Void data) {
            AstNode child = node.getFirstChild();
            while (child != null) {
                AstNode next = child.getNextSibling();
                child.acceptVisitor(this, data);
                child = next;
            }
            return null;
        }

        @Override
        public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
            MethodDefinition m3 = node.getUserData(Keys.METHOD_DEFINITION);
            if (ClassMethodLocator.isClassMethodCandidate(m3) && PATTERN.matches(node)) {
                this.classMethod = m3;
            }
            return null;
        }

        static boolean isClassMethodCandidate(MethodDefinition m3) {
            return m3 != null && m3.isSynthetic() && m3.isStatic() && m3.isPackagePrivate() && m3.getParameters().size() == 1 && CommonTypeReferences.Class.isEquivalentTo(m3.getReturnType()) && CommonTypeReferences.String.isEquivalentTo(m3.getParameters().get(0).getParameterType());
        }

        private static MethodDeclaration createPattern() {
            MethodDeclaration method = new MethodDeclaration();
            MetadataParser parser = new MetadataParser();
            TypeReference classNotFoundException = parser.parseTypeDescriptor("java/lang/ClassNotFoundException");
            TypeReference noClassDefFoundError = parser.parseTypeDescriptor("java/lang/NoClassDefFoundError");
            AstType classType = new AstTypeMatch(CommonTypeReferences.Class).toType();
            AstType throwable = new AstTypeMatch(CommonTypeReferences.Throwable).toType();
            method.setName("$any$");
            method.getModifiers().add(new JavaModifierToken(Modifier.STATIC));
            method.setReturnType(classType);
            method.getParameters().add(new ParameterDeclaration("$any$", new AstTypeMatch(CommonTypeReferences.String).toType()));
            BlockStatement tryBlock = new BlockStatement(classType.clone().makeReference().invoke("forName", new ParameterReferenceNode(0).toExpression()).makeReturn());
            BlockStatement catchBlock = new Choice(new BlockStatement(new AstTypeMatch(noClassDefFoundError).toType().makeNew().invoke("initCause", new IdentifierExpressionBackReference("catch").toExpression().cast(throwable)).makeThrow()), new BlockStatement(new AstTypeMatch(noClassDefFoundError).toType().makeNew(new IdentifierExpressionBackReference("catch").toExpression().invoke("getMessage", new Expression[0])).makeThrow())).toBlockStatement();
            CatchClause catchClause = new CatchClause();
            catchClause.setVariableName("$any$");
            catchClause.getExceptionTypes().add(new AstTypeMatch(classNotFoundException).toType());
            catchClause.setBody(catchBlock);
            TryCatchStatement tryCatch = new TryCatchStatement();
            tryCatch.setTryBlock(tryBlock);
            tryCatch.getCatchClauses().add(new NamedNode("catch", catchClause).toCatchClause());
            method.setBody(new BlockStatement(new VariableDeclarationStatement(new AstTypeMatch(classNotFoundException).toType(), "$any$").makeOptional().toStatement(), tryCatch));
            return method;
        }
    }
}

