/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.collections;

import com.strobel.annotations.NotNull;
import com.strobel.collections.ListBuffer;
import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class ImmutableList<A>
extends AbstractCollection<A>
implements List<A> {
    public A head;
    public ImmutableList<A> tail;
    private static final ImmutableList<?> EMPTY_LIST = new ImmutableList<Object>(null, null){

        @Override
        public ImmutableList<Object> setTail(ImmutableList<Object> tail) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };
    private static final Iterator<?> EMPTY_ITERATOR = new Iterator<Object>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    ImmutableList(A head, ImmutableList<A> tail) {
        this.tail = tail;
        this.head = head;
    }

    public static <A> ImmutableList<A> empty() {
        return EMPTY_LIST;
    }

    public static <A> ImmutableList<A> of(A x1) {
        return new ImmutableList<A>(x1, ImmutableList.empty());
    }

    @SafeVarargs
    public static <A> ImmutableList<A> of(A x1, A ... rest) {
        return new ImmutableList<A>(x1, ImmutableList.from(rest));
    }

    public static <A> ImmutableList<A> of(A x1, A x2) {
        return new ImmutableList<A>(x1, ImmutableList.of(x2));
    }

    public static <A> ImmutableList<A> of(A x1, A x2, A x3) {
        return new ImmutableList<A>(x1, ImmutableList.of(x2, x3));
    }

    public static <A> ImmutableList<A> of(A x1, A x2, A x3, A ... rest) {
        return new ImmutableList<A>(x1, new ImmutableList<A>(x2, new ImmutableList<A>(x3, ImmutableList.from(rest))));
    }

    public static <A> ImmutableList<A> from(A[] array) {
        ImmutableList<A> xs = ImmutableList.empty();
        if (array != null) {
            for (int i = array.length - 1; i >= 0; --i) {
                xs = new ImmutableList<A>(array[i], xs);
            }
        }
        return xs;
    }

    @Deprecated
    public static <A> ImmutableList<A> fill(int len, A init) {
        ImmutableList<A> l = ImmutableList.empty();
        for (int i = 0; i < len; ++i) {
            l = new ImmutableList<A>(init, l);
        }
        return l;
    }

    @Override
    public boolean isEmpty() {
        return this.tail == null;
    }

    public boolean nonEmpty() {
        return this.tail != null;
    }

    public int length() {
        ImmutableList<A> l = this;
        int len = 0;
        while (l.tail != null) {
            l = l.tail;
            ++len;
        }
        return len;
    }

    @Override
    public int size() {
        return this.length();
    }

    public ImmutableList<A> setTail(ImmutableList<A> tail) {
        this.tail = tail;
        return tail;
    }

    public ImmutableList<A> prepend(A x) {
        return new ImmutableList<A>(x, this);
    }

    public ImmutableList<A> prependList(ImmutableList<A> xs) {
        if (this.isEmpty()) {
            return xs;
        }
        if (xs.isEmpty()) {
            return this;
        }
        if (xs.tail.isEmpty()) {
            return this.prepend(xs.head);
        }
        ImmutableList<A> result = this;
        ImmutableList<A> rev = xs.reverse();
        assert (rev != xs);
        while (rev.nonEmpty()) {
            ImmutableList<A> h2 = rev;
            rev = rev.tail;
            h2.setTail(result);
            result = h2;
        }
        return result;
    }

    public ImmutableList<A> reverse() {
        if (this.isEmpty() || this.tail.isEmpty()) {
            return this;
        }
        ImmutableList<A> rev = ImmutableList.empty();
        ImmutableList<A> l = this;
        while (l.nonEmpty()) {
            rev = new ImmutableList<A>(l.head, rev);
            l = l.tail;
        }
        return rev;
    }

    public ImmutableList<A> append(A x) {
        return ImmutableList.of(x).prependList(this);
    }

    public ImmutableList<A> appendList(ImmutableList<A> x) {
        return x.prependList(this);
    }

    public ImmutableList<A> appendList(ListBuffer<A> x) {
        return this.appendList(x.toList());
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] vec) {
        int i;
        ImmutableList<A> l = this;
        for (i = 0; l.nonEmpty() && i < vec.length; ++i) {
            vec[i] = l.head;
            l = l.tail;
        }
        if (l.isEmpty()) {
            if (i < vec.length) {
                vec[i] = null;
            }
            return vec;
        }
        return this.toArray((Object[])Array.newInstance(vec.getClass().getComponentType(), this.size()));
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    public String toString(String sep) {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.head);
        ImmutableList<A> l = this.tail;
        while (l.nonEmpty()) {
            buffer.append(sep);
            buffer.append(l.head);
            l = l.tail;
        }
        return buffer.toString();
    }

    @Override
    public String toString() {
        return this.toString(",");
    }

    @Override
    public int hashCode() {
        ImmutableList<A> l = this;
        int h2 = 1;
        while (l.tail != null) {
            h2 = h2 * 31 + (l.head == null ? 0 : l.head.hashCode());
            l = l.tail;
        }
        return h2;
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ImmutableList) {
            return ImmutableList.equals(this, (ImmutableList)other);
        }
        if (other instanceof List) {
            ImmutableList<A> t = this;
            Iterator it = ((List)other).iterator();
            while (t.tail != null && it.hasNext()) {
                Object o = it.next();
                if (!(t.head != null ? t.head.equals(o) : o == null)) {
                    return false;
                }
                t = t.tail;
            }
            return t.isEmpty() && !it.hasNext();
        }
        return false;
    }

    public static boolean equals(ImmutableList<?> xs, ImmutableList<?> ys) {
        while (xs.tail != null && ys.tail != null) {
            if (xs.head == null ? ys.head != null : !xs.head.equals(ys.head)) {
                return false;
            }
            xs = xs.tail;
            ys = ys.tail;
        }
        return xs.tail == null && ys.tail == null;
    }

    @Override
    public boolean contains(Object x) {
        ImmutableList<A> l = this;
        while (l.tail != null) {
            if (x == null ? l.head == null : l.head.equals(x)) {
                return true;
            }
            l = l.tail;
        }
        return false;
    }

    public A last() {
        A last = null;
        ImmutableList<A> t = this;
        while (t.tail != null) {
            last = t.head;
            t = t.tail;
        }
        return last;
    }

    public static <T> ImmutableList<T> convert(Class<T> type, ImmutableList<?> list) {
        if (list == null) {
            return null;
        }
        for (Object o : list) {
            type.cast(o);
        }
        return list;
    }

    private static <A> Iterator<A> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    @NotNull
    public Iterator<A> iterator() {
        if (this.tail == null) {
            return ImmutableList.emptyIterator();
        }
        return new Iterator<A>(){
            private ImmutableList<A> _elements;
            {
                this._elements = ImmutableList.this;
            }

            @Override
            public boolean hasNext() {
                return this._elements.tail != null;
            }

            @Override
            public A next() {
                if (this._elements.tail == null) {
                    throw new NoSuchElementException();
                }
                Object result = this._elements.head;
                this._elements = this._elements.tail;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public A get(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        ImmutableList<A> l = this;
        int i = index;
        while (i-- > 0 && !l.isEmpty()) {
            l = l.tail;
        }
        if (l.isEmpty()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size());
        }
        return l.head;
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends A> c) {
        if (c.isEmpty()) {
            return false;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public A set(int index, A element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int index, A element) {
        throw new UnsupportedOperationException();
    }

    @Override
    public A remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        ImmutableList<A> l = this;
        while (l.tail != null) {
            if (l.head == null ? o == null : l.head.equals(o)) {
                return i;
            }
            l = l.tail;
            ++i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int last = -1;
        int i = 0;
        ImmutableList<A> l = this;
        while (l.tail != null) {
            if (l.head == null ? o == null : l.head.equals(o)) {
                last = i;
            }
            l = l.tail;
            ++i;
        }
        return last;
    }

    @Override
    @NotNull
    public ListIterator<A> listIterator() {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator();
    }

    @Override
    @NotNull
    public ListIterator<A> listIterator(int index) {
        return Collections.unmodifiableList(new ArrayList(this)).listIterator(index);
    }

    @Override
    @NotNull
    public List<A> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IllegalArgumentException();
        }
        ArrayList<A> a = new ArrayList<A>(toIndex - fromIndex);
        ImmutableList<A> l = this;
        for (int i = 0; l.tail != null && i != toIndex; ++i) {
            if (i >= fromIndex) {
                a.add(l.head);
            }
            l = l.tail;
        }
        return Collections.unmodifiableList(a);
    }
}

