/*
 * Decompiled with CFR 0.152.
 */
package com.github.swingdpi;

import com.github.swingdpi.DpiUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.BorderFactory;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class UiScaling {
    private static final AtomicInteger s_scalingPercentage = new AtomicInteger(DpiUtils.getClosestStandardScaling());
    private static final List<ChangeListener> s_changeListeners = new ArrayList<ChangeListener>();

    private UiScaling() {
    }

    public static float getScalingFactor() {
        return (float)UiScaling.getScaling() / 100.0f;
    }

    public static int getScaling() {
        return s_scalingPercentage.get();
    }

    public static void setScaling(int scalingInPercent) {
        assert (SwingUtilities.isEventDispatchThread());
        int old = s_scalingPercentage.getAndSet(scalingInPercent);
        if (old != scalingInPercent) {
            UiScaling.notifyListeners();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListeners() {
        ArrayList<ChangeListener> listeners;
        List<ChangeListener> list = s_changeListeners;
        synchronized (list) {
            listeners = new ArrayList<ChangeListener>(s_changeListeners);
        }
        for (ChangeListener changeListener : listeners) {
            changeListener.stateChanged(new ChangeEvent(UiScaling.class));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addChangeListener(ChangeListener listener) {
        List<ChangeListener> list = s_changeListeners;
        synchronized (list) {
            s_changeListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChangeListener(ChangeListener listener) {
        List<ChangeListener> list = s_changeListeners;
        synchronized (list) {
            s_changeListeners.remove(listener);
        }
    }

    public static Dimension newDimension(int width, int height) {
        return UiScaling.scale(new Dimension(width, height));
    }

    public static int scale(int i) {
        return Math.round((float)(i * UiScaling.getScaling()) / 100.0f);
    }

    public static float scale(float f) {
        return f * UiScaling.getScalingFactor();
    }

    public static Dimension scale(Dimension dim) {
        return UiScaling.getScaling() == 100 ? dim : new Dimension(UiScaling.scale(dim.width), UiScaling.scale(dim.height));
    }

    public static Font scale(Font font) {
        return font.deriveFont(font.getSize2D() * UiScaling.getScalingFactor());
    }

    public static Border createEmptyBorder(int top, int left, int bottom, int right) {
        return BorderFactory.createEmptyBorder(UiScaling.scale(top), UiScaling.scale(left), UiScaling.scale(bottom), UiScaling.scale(right));
    }

    public static Border createLineBorder(Color color, int thickness) {
        return BorderFactory.createLineBorder(color, UiScaling.scale(thickness));
    }

    public static Border createMatteBorder(int top, int left, int bottom, int right, Color color) {
        return BorderFactory.createMatteBorder(UiScaling.scale(top), UiScaling.scale(left), UiScaling.scale(bottom), UiScaling.scale(right), color);
    }
}

