/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.iconloader.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil {
    public static List<String> split(String s2, String separator) {
        return StringUtil.split(s2, separator, true);
    }

    public static List<String> split(String s2, String separator, boolean excludeSeparator) {
        return StringUtil.split(s2, separator, excludeSeparator, true);
    }

    public static List<String> split(String s2, String separator, boolean excludeSeparator, boolean excludeEmptyStrings) {
        int index;
        if (separator.isEmpty()) {
            return Collections.singletonList(s2);
        }
        ArrayList<String> result = new ArrayList<String>();
        int pos = 0;
        while ((index = s2.indexOf(separator, pos)) != -1) {
            int nextPos = index + separator.length();
            String token = s2.substring(pos, excludeSeparator ? index : nextPos);
            if (!token.isEmpty() || !excludeEmptyStrings) {
                result.add(token);
            }
            pos = nextPos;
        }
        if (pos < s2.length() || !excludeEmptyStrings && pos == s2.length()) {
            result.add(s2.substring(pos, s2.length()));
        }
        return result;
    }

    public static int indexOfIgnoreCase(String where, String what, int fromIndex) {
        int targetCount = what.length();
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = what.charAt(0);
        int max = sourceCount - targetCount;
        for (int i = fromIndex; i <= max; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                while (++i <= max && !StringUtil.charsEqualIgnoreCase(where.charAt(i), first)) {
                }
            }
            if (i > max) continue;
            int j = i + 1;
            int end = j + targetCount - 1;
            int k = 1;
            while (j < end && StringUtil.charsEqualIgnoreCase(where.charAt(j), what.charAt(k))) {
                ++j;
                ++k;
            }
            if (j != end) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfIgnoreCase(String where, char what, int fromIndex) {
        int sourceCount = where.length();
        if (fromIndex >= sourceCount) {
            return -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        for (int i = fromIndex; i < sourceCount; ++i) {
            if (!StringUtil.charsEqualIgnoreCase(where.charAt(i), what)) continue;
            return i;
        }
        return -1;
    }

    public static boolean containsIgnoreCase(String where, String what) {
        return StringUtil.indexOfIgnoreCase(where, what, 0) >= 0;
    }

    public static boolean charsEqualIgnoreCase(char a, char b) {
        return a == b || StringUtil.toUpperCase(a) == StringUtil.toUpperCase(b) || StringUtil.toLowerCase(a) == StringUtil.toLowerCase(b);
    }

    public static char toUpperCase(char a) {
        if (a < 'a') {
            return a;
        }
        if (a <= 'z') {
            return (char)(a + -32);
        }
        return Character.toUpperCase(a);
    }

    public static char toLowerCase(char a) {
        if (a < 'A' || a >= 'a' && a <= 'z') {
            return a;
        }
        if (a <= 'Z') {
            return (char)(a + 32);
        }
        return Character.toLowerCase(a);
    }

    public static int compareVersionNumbers(String v1, String v2) {
        String[] parts;
        int idx;
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            return -1;
        }
        if (v2 == null) {
            return 1;
        }
        String[] part1 = v1.split("[\\.\\_\\-]");
        String[] part2 = v2.split("[\\.\\_\\-]");
        for (idx = 0; idx < part1.length && idx < part2.length; ++idx) {
            String p1 = part1[idx];
            String p2 = part2[idx];
            int cmp = p1.matches("\\d+") && p2.matches("\\d+") ? new Integer(p1).compareTo(new Integer(p2)) : part1[idx].compareTo(part2[idx]);
            if (cmp == 0) continue;
            return cmp;
        }
        if (part1.length == part2.length) {
            return 0;
        }
        boolean left = part1.length > idx;
        String[] stringArray = parts = left ? part1 : part2;
        while (idx < parts.length) {
            String p = parts[idx];
            int cmp = p.matches("\\d+") ? new Integer(p).compareTo(0) : 1;
            if (cmp != 0) {
                return left ? cmp : -cmp;
            }
            ++idx;
        }
        return 0;
    }

    public static boolean startsWithChar(CharSequence s2, char prefix) {
        return s2 != null && s2.length() != 0 && s2.charAt(0) == prefix;
    }

    public static boolean endsWithChar(CharSequence s2, char suffix) {
        return s2 != null && s2.length() != 0 && s2.charAt(s2.length() - 1) == suffix;
    }

    public static String stripQuotesAroundValue(String text) {
        if (StringUtil.startsWithChar(text, '\"') || StringUtil.startsWithChar(text, '\'')) {
            text = text.substring(1);
        }
        if (StringUtil.endsWithChar(text, '\"') || StringUtil.endsWithChar(text, '\'')) {
            text = text.substring(0, text.length() - 1);
        }
        return text;
    }

    public static boolean startsWithConcatenation(String string, String ... prefixes) {
        int offset = 0;
        for (String prefix : prefixes) {
            int prefixLen = prefix.length();
            if (!string.regionMatches(offset, prefix, 0, prefixLen)) {
                return false;
            }
            offset += prefixLen;
        }
        return true;
    }

    public static String getFileExtension(String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    public static String getFileNameWithoutExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i != -1) {
            name = name.substring(0, i);
        }
        return name;
    }

    @NotNull
    @Contract(pure=true)
    public static String join(@NotNull Collection<String> strings, @NotNull String separator) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        if (strings.size() <= 1) {
            String string = StringUtil.notNullize(StringUtil.getFirstItem(strings));
            if (string == null) {
                StringUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(strings, separator, result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Contract(pure=true)
    public static String join(@NotNull Iterable<?> items, @NotNull @NonNls String separator) {
        if (items == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        StringBuilder result = new StringBuilder();
        for (Object item : items) {
            result.append(item).append(separator);
        }
        if (result.length() > 0) {
            result.setLength(result.length() - separator.length());
        }
        return result.toString();
    }

    @NotNull
    public static String notNullize(@Nullable String s2) {
        String string = StringUtil.notNullize(s2, "");
        if (string == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public static String notNullize(@Nullable String s2, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        String string = s2 == null ? defaultValue : s2;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    public static void join(@NotNull Collection<String> strings, @NotNull String separator, @NotNull StringBuilder result) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (separator == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        boolean isFirst = true;
        for (String string : strings) {
            if (string == null) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                result.append(separator);
            }
            result.append(string);
        }
    }

    @Nullable
    public static <T> T getFirstItem(@Nullable Collection<T> items) {
        return items == null || items.isEmpty() ? null : (T)items.iterator().next();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 1: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separator";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/bulenkov/iconloader/util/StringUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/bulenkov/iconloader/util/StringUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "notNullize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notNullize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

