/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.ui.DarculaRootPaneUI;
import com.bulenkov.darcula.util.ImageUtil;
import com.bulenkov.iconloader.util.ColorUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicButtonUI;
import sun.swing.SwingUtilities2;

public class DarculaTitlePane
extends JComponent {
    private static final int IMAGE_HEIGHT = 16;
    private static final int IMAGE_WIDTH = 16;
    private PropertyChangeListener propertyChangeListener;
    private JMenuBar menuBar;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton toggleButton;
    private JButton iconifyButton;
    private JButton closeButton;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private Image appIcon;
    private WindowListener windowListener;
    private Window window;
    private JRootPane rootPane;
    private int state;
    private DarculaRootPaneUI rootPaneUI;
    private int buttonAreaWidth;
    private Color activeBackground = null;
    private Color activeForeground = null;
    private static final int TITLE_PADDING = 5;

    public DarculaTitlePane(JRootPane root, DarculaRootPaneUI ui) {
        this.rootPane = root;
        this.rootPaneUI = ui;
        this.state = -1;
        this.installSubcomponents();
        this.determineColors();
        this.installDefaults();
        this.setLayout(this.createLayout());
    }

    private void uninstall() {
        this.uninstallListeners();
        this.window = null;
        this.removeAll();
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    @Override
    public JRootPane getRootPane() {
        return this.rootPane;
    }

    private int getWindowDecorationStyle() {
        return this.getRootPane().getWindowDecorationStyle();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(((Frame)this.window).getExtendedState());
            } else {
                this.setState(0);
            }
            this.setActive(this.window.isActive());
            this.installListeners();
            this.updateSystemIcon();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installSubcomponents() {
        int decorationStyle = this.getWindowDecorationStyle();
        if (decorationStyle == 1) {
            this.createActions();
            this.menuBar = this.createMenuBar();
            this.add(this.menuBar);
            this.createButtons();
            this.add(this.iconifyButton);
            this.add(this.toggleButton);
            this.add(this.closeButton);
        } else if (decorationStyle == 2 || decorationStyle == 3 || decorationStyle == 4 || decorationStyle == 5 || decorationStyle == 6 || decorationStyle == 7 || decorationStyle == 8) {
            this.createActions();
            this.createButtons();
            this.add(this.closeButton);
        }
    }

    private void determineColors() {
        switch (this.getWindowDecorationStyle()) {
            default: {
                break;
            }
            case 4: {
                this.activeBackground = UIManager.getColor("OptionPane.errorDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.errorDialog.titlePane.foreground");
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                this.activeBackground = UIManager.getColor("OptionPane.questionDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.questionDialog.titlePane.foreground");
                break;
            }
            case 8: {
                this.activeBackground = UIManager.getColor("OptionPane.warningDialog.titlePane.background");
                this.activeForeground = UIManager.getColor("OptionPane.warningDialog.titlePane.foreground");
            }
        }
        if (this.activeBackground == null) {
            this.activeBackground = UIManager.getColor("darcula.background");
        }
        if (this.activeForeground == null) {
            this.activeForeground = UIManager.getColor("OptionPane.foreground");
        }
    }

    private void installDefaults() {
        this.setFont(UIManager.getFont("InternalFrame.titleFont", this.getLocale()));
    }

    protected JMenuBar createMenuBar() {
        this.menuBar = new SystemMenuBar();
        this.menuBar.setFocusable(false);
        this.menuBar.setBorderPainted(true);
        this.menuBar.add(this.createMenu());
        return this.menuBar;
    }

    private void close() {
        Window window = this.getWindow();
        if (window != null) {
            window.dispatchEvent(new WindowEvent(window, 201));
        }
    }

    private void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 1);
        }
    }

    private void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            frame.setExtendedState(this.state | 6);
        }
    }

    private void restore() {
        Frame frame = this.getFrame();
        if (frame == null) {
            return;
        }
        if ((this.state & 1) != 0) {
            frame.setExtendedState(this.state & 0xFFFFFFFE);
        } else {
            frame.setExtendedState(this.state & 0xFFFFFFF9);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyAction = new IconifyAction();
            this.restoreAction = new RestoreAction();
            this.maximizeAction = new MaximizeAction();
        }
    }

    private JMenu createMenu() {
        JMenu systemMenu = new JMenu("");
        systemMenu.setOpaque(false);
        if (this.appIcon != null) {
            systemMenu.setIcon(new ImageIcon(this.appIcon));
        }
        if (this.getWindowDecorationStyle() == 1) {
            this.addMenuItems(systemMenu);
        }
        return systemMenu;
    }

    private void addMenuItems(JMenu menu) {
        menu.add(this.restoreAction);
        menu.add(this.iconifyAction);
        if (Toolkit.getDefaultToolkit().isFrameStateSupported(6)) {
            menu.add(this.maximizeAction);
        }
        menu.add(new JSeparator());
        menu.add(this.closeAction);
    }

    private JButton createButton(String accessibleName, Icon icon, Action action) {
        JButton button = new JButton();
        button.setUI(new DarculaRootPaneButtonUI());
        button.setFocusPainted(false);
        button.setFocusable(false);
        button.setOpaque(true);
        button.setContentAreaFilled(false);
        button.putClientProperty("paintActive", Boolean.TRUE);
        button.putClientProperty("AccessibleName", accessibleName);
        button.setBorder(BorderFactory.createEmptyBorder());
        button.setAction(action);
        button.setToolTipText((String)action.getValue("Name"));
        button.setText(null);
        button.setIcon(icon);
        button.setRolloverEnabled(true);
        return button;
    }

    private void createButtons() {
        this.closeButton = this.createButton("Close", UIManager.getIcon("InternalFrame.closeIcon"), this.closeAction);
        if (this.getWindowDecorationStyle() == 1) {
            this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
            this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
            this.iconifyButton = this.createButton("Iconify", UIManager.getIcon("InternalFrame.iconifyIcon"), this.iconifyAction);
            this.toggleButton = this.createButton("Maximize", this.maximizeIcon, this.restoreAction);
        }
    }

    private LayoutManager createLayout() {
        return new TitlePaneLayout();
    }

    private void setActive(boolean active) {
        this.closeButton.putClientProperty("paintActive", active);
        if (this.getWindowDecorationStyle() == 1) {
            this.iconifyButton.putClientProperty("paintActive", active);
            this.toggleButton.putClientProperty("paintActive", active);
        }
        this.getRootPane().repaint();
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        Window wnd = this.getWindow();
        if (wnd != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                JRootPane rootPane = this.getRootPane();
                if ((state & 6) != 0 && (rootPane.getBorder() == null || rootPane.getBorder() instanceof UIResource) && frame.isShowing()) {
                    rootPane.setBorder(null);
                } else if ((state & 6) == 0) {
                    this.rootPaneUI.installBorder(rootPane);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateToggleButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateToggleButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.toggleButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.toggleButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.toggleButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.toggleButton.getParent() != null) {
                        this.remove(this.toggleButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.toggleButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateToggleButton(Action action, Icon icon) {
        this.toggleButton.setAction(action);
        this.toggleButton.setIcon(icon);
        this.toggleButton.setText(null);
    }

    private Frame getFrame() {
        Window window = this.getWindow();
        if (window instanceof Frame) {
            return (Frame)window;
        }
        return null;
    }

    private Window getWindow() {
        return this.window;
    }

    private String getTitle() {
        Window w = this.getWindow();
        if (w instanceof Frame) {
            return ((Frame)w).getTitle();
        }
        if (w instanceof Dialog) {
            return ((Dialog)w).getTitle();
        }
        return null;
    }

    @Override
    public void paintComponent(Graphics g2) {
        String theTitle;
        int xOffset;
        if (this.getFrame() != null) {
            this.setState(this.getFrame().getExtendedState());
        }
        JRootPane rootPane = this.getRootPane();
        Window window = this.getWindow();
        boolean leftToRight = window == null ? rootPane.getComponentOrientation().isLeftToRight() : window.getComponentOrientation().isLeftToRight();
        int width = this.getWidth();
        int height = this.getHeight();
        Color background = this.activeBackground;
        Color foreground = this.activeForeground;
        g2.setColor(background);
        g2.fillRect(0, 0, width, height);
        int n = xOffset = leftToRight ? 5 : width - 5;
        if (this.getWindowDecorationStyle() == 1) {
            xOffset += leftToRight ? 21 : -21;
        }
        if ((theTitle = this.getTitle()) != null) {
            FontMetrics fm = rootPane.getFontMetrics(g2.getFont());
            g2.setColor(foreground);
            int yOffset = (height - fm.getHeight()) / 2 + fm.getAscent();
            Rectangle rect = new Rectangle(0, 0, 0, 0);
            if (this.iconifyButton != null && this.iconifyButton.getParent() != null) {
                rect = this.iconifyButton.getBounds();
            }
            if (leftToRight) {
                if (rect.x == 0) {
                    rect.x = window.getWidth() - window.getInsets().right - 2;
                }
                int titleW = rect.x - xOffset - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
            } else {
                int titleW = xOffset - rect.x - rect.width - 4;
                theTitle = SwingUtilities2.clipStringIfNecessary(rootPane, fm, theTitle, titleW);
                xOffset -= SwingUtilities.computeStringWidth(fm, theTitle);
            }
            int titleLength = SwingUtilities2.stringWidth(rootPane, fm, theTitle);
            SwingUtilities2.drawString((JComponent)rootPane, g2, theTitle, xOffset, yOffset);
            xOffset += leftToRight ? titleLength + 5 : -5;
        }
    }

    private void updateSystemIcon() {
        Window window = this.getWindow();
        if (window == null) {
            this.appIcon = null;
            return;
        }
        List<Image> icons = window.getIconImages();
        assert (icons != null);
        this.appIcon = icons.size() == 0 ? null : (icons.size() == 1 ? icons.get(0) : ImageUtil.getScaledIconImage(icons, 16, 16));
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            DarculaTitlePane.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = DarculaTitlePane.this.getFrame();
                if (frame != null) {
                    DarculaTitlePane.this.setState(frame.getExtendedState(), true);
                }
                if ("resizable".equals(name)) {
                    DarculaTitlePane.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                DarculaTitlePane.this.repaint();
            } else if ("componentOrientation" == name) {
                DarculaTitlePane.this.revalidate();
                DarculaTitlePane.this.repaint();
            } else if ("iconImage" == name) {
                DarculaTitlePane.this.updateSystemIcon();
                DarculaTitlePane.this.revalidate();
                DarculaTitlePane.this.repaint();
            }
        }
    }

    private class DarculaRootPaneButtonUI
    extends BasicButtonUI {
        private DarculaRootPaneButtonUI() {
        }

        private Color getMainButtonColor(AbstractButton b) {
            return UIManager.getColor(b == DarculaTitlePane.this.closeButton ? "DarculaTitlePane.hovered.closeButtonColor" : "DarculaTitlePane.hovered.buttonColor");
        }

        @Override
        public void paint(Graphics g2, JComponent c) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            Color prevColor = g2.getColor();
            if (model.isArmed()) {
                Color color = this.getMainButtonColor(b);
                color = ColorUtil.shift(color, b == DarculaTitlePane.this.closeButton ? 0.8 : 0.95);
                g2.setColor(color);
                g2.fillRect(0, 0, b.getWidth(), b.getHeight());
            } else if (model.isRollover() || model.isSelected()) {
                Color color = this.getMainButtonColor(b);
                g2.setColor(color);
                g2.fillRect(0, 0, b.getWidth(), b.getHeight());
            }
            g2.setColor(prevColor);
            super.paint(g2, c);
        }
    }

    private class TitlePaneLayout
    implements LayoutManager {
        private TitlePaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int height = this.computeHeight();
            return new Dimension(height, height);
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        private int computeHeight() {
            FontMetrics fm = DarculaTitlePane.this.rootPane.getFontMetrics(DarculaTitlePane.this.getFont());
            int fontHeight = fm.getHeight();
            fontHeight += 7;
            int iconHeight = 0;
            if (DarculaTitlePane.this.getWindowDecorationStyle() == 1) {
                iconHeight = 16;
            }
            return Math.max(fontHeight, iconHeight);
        }

        private void layoutContainerOsX(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = DarculaTitlePane.this.window == null ? DarculaTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : DarculaTitlePane.this.window.getComponentOrientation().isLeftToRight();
            leftToRight = !leftToRight;
            int w = DarculaTitlePane.this.getWidth();
            int y = 0;
            int buttonCount = 0;
            if (DarculaTitlePane.this.closeButton != null && DarculaTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = DarculaTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = DarculaTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            buttonWidth += 16;
            buttonHeight += 8;
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - 16 - spacing;
            if (DarculaTitlePane.this.menuBar != null) {
                int menuBarY = (DarculaTitlePane.this.getHeight() - ((DarculaTitlePane)DarculaTitlePane.this).menuBar.getPreferredSize().height) / 2;
                DarculaTitlePane.this.menuBar.setBounds(x, menuBarY, 16, 16);
            }
            int n2 = x = leftToRight ? w - buttonWidth : 0;
            if (DarculaTitlePane.this.closeButton != null) {
                DarculaTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
                DarculaTitlePane.this.closeButton.repaint();
                ++buttonCount;
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            spacing = 2;
            if (DarculaTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && DarculaTitlePane.this.iconifyButton.getParent() != null) {
                    DarculaTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                    ++buttonCount;
                }
                if (DarculaTitlePane.this.toggleButton != null && DarculaTitlePane.this.toggleButton.getParent() != null) {
                    DarculaTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                    ++buttonCount;
                }
            }
            DarculaTitlePane.this.buttonAreaWidth = buttonCount * buttonWidth;
        }

        @Override
        public void layoutContainer(Container c) {
            int buttonWidth;
            int buttonHeight;
            boolean leftToRight = DarculaTitlePane.this.window == null ? DarculaTitlePane.this.getRootPane().getComponentOrientation().isLeftToRight() : DarculaTitlePane.this.window.getComponentOrientation().isLeftToRight();
            int w = DarculaTitlePane.this.getWidth();
            int y = 0;
            if (DarculaTitlePane.this.closeButton != null && DarculaTitlePane.this.closeButton.getIcon() != null) {
                buttonHeight = DarculaTitlePane.this.closeButton.getIcon().getIconHeight();
                buttonWidth = DarculaTitlePane.this.closeButton.getIcon().getIconWidth();
            } else {
                buttonHeight = 16;
                buttonWidth = 16;
            }
            buttonWidth += 16;
            buttonHeight += 8;
            int x = leftToRight ? w : 0;
            int spacing = 5;
            int n = x = leftToRight ? spacing : w - 16 - spacing;
            if (DarculaTitlePane.this.menuBar != null) {
                int menuBarY = (DarculaTitlePane.this.getHeight() - ((DarculaTitlePane)DarculaTitlePane.this).menuBar.getPreferredSize().height) / 2;
                DarculaTitlePane.this.menuBar.setBounds(x, menuBarY, 16, 16);
            }
            int n2 = x = leftToRight ? w - buttonWidth : 0;
            if (DarculaTitlePane.this.closeButton != null) {
                DarculaTitlePane.this.closeButton.setBounds(x, y, buttonWidth, buttonHeight);
                DarculaTitlePane.this.closeButton.repaint();
            }
            if (!leftToRight) {
                x += buttonWidth;
            }
            spacing = 2;
            if (DarculaTitlePane.this.getWindowDecorationStyle() == 1) {
                if (Toolkit.getDefaultToolkit().isFrameStateSupported(6) && DarculaTitlePane.this.toggleButton.getParent() != null) {
                    DarculaTitlePane.this.toggleButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
                if (DarculaTitlePane.this.iconifyButton != null && DarculaTitlePane.this.iconifyButton.getParent() != null) {
                    DarculaTitlePane.this.iconifyButton.setBounds(x += leftToRight ? -spacing - buttonWidth : spacing, y, buttonWidth, buttonHeight);
                    if (!leftToRight) {
                        x += buttonWidth;
                    }
                }
            }
        }
    }

    private class SystemMenuBar
    extends JMenuBar {
        private SystemMenuBar() {
        }

        @Override
        public void paint(Graphics g2) {
            if (this.isOpaque()) {
                g2.setColor(this.getBackground());
                g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            if (DarculaTitlePane.this.appIcon != null) {
                g2.drawImage(DarculaTitlePane.this.appIcon, 0, 0, 16, 16, null);
            } else {
                Icon icon = UIManager.getIcon("InternalFrame.icon");
                if (icon != null) {
                    icon.paintIcon(this, g2, 0, 0);
                }
            }
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(16, size.width), Math.max(size.height, 16));
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        public MaximizeAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.maximizeTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        public RestoreAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.restoreTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        public IconifyAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.iconifyTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(UIManager.getString((Object)"DarculaTitlePane.closeTitle", DarculaTitlePane.this.getLocale()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DarculaTitlePane.this.close();
        }
    }
}

