/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.darcula.DarculaUIUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.GraphicsConfig;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.metal.MetalRadioButtonUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class DarculaRadioButtonUI
extends MetalRadioButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new DarculaRadioButtonUI();
    }

    @Override
    public synchronized void paint(Graphics g2d, JComponent c) {
        Graphics2D g2 = (Graphics2D)g2d;
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        Dimension size = c.getSize();
        Font f = c.getFont();
        g2.setFont(f);
        FontMetrics fm = SwingUtilities2.getFontMetrics(c, g2, f);
        Rectangle viewRect = new Rectangle(size);
        Rectangle iconRect = new Rectangle();
        Rectangle textRect = new Rectangle();
        Insets i = c.getInsets();
        viewRect.x += i.left;
        viewRect.y += i.top;
        viewRect.width -= i.right + viewRect.x;
        viewRect.height -= i.bottom + viewRect.y;
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), this.getDefaultIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getIconTextGap());
        if (c.isOpaque()) {
            g2.setColor(b.getBackground());
            g2.fillRect(0, 0, size.width, size.height);
        }
        int rad = 5;
        int x = iconRect.x + (rad - 1) / 2;
        int y = iconRect.y + (rad - 1) / 2;
        int w = iconRect.width - (rad + 5) / 2;
        int h2 = iconRect.height - (rad + 5) / 2;
        g2.translate(x, y);
        GraphicsConfig config = GraphicsUtil.setupAAPainting(g2);
        boolean focus = b.hasFocus();
        g2.setColor(UIManager.getColor("CheckBox.darcula.checkBoxBackgroundColor"));
        if (focus) {
            g2.fillOval(0, 1, w, h2);
        } else {
            g2.fillOval(0, 1, w - 1, h2 - 1);
        }
        if (focus) {
            if (UIUtil.isRetina()) {
                DarculaUIUtil.paintFocusOval(g2, 1, 2, w - 2, h2 - 2);
            } else {
                DarculaUIUtil.paintFocusOval(g2, 0, 1, w, h2);
            }
        } else {
            g2.setColor(UIManager.getColor("CheckBox.darcula.checkBoxBorderColor"));
            g2.drawOval(0, 1, w - 1, h2 - 1);
        }
        if (b.isSelected()) {
            boolean enabled = b.isEnabled();
            g2.setColor(UIManager.getColor(enabled ? "RadioButton.darcula.selectionEnabledColor" : "RadioButton.darcula.selectionDisabledColor"));
            g2.fillOval(w / 2 - rad / 2, h2 / 2 - 1, rad, rad);
        }
        config.restore();
        g2.translate(-x, -y);
        if (text != null) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                v.paint(g2, textRect);
            } else {
                int mnemIndex = b.getDisplayedMnemonicIndex();
                if (model.isEnabled()) {
                    g2.setColor(b.getForeground());
                } else {
                    g2.setColor(this.getDisabledTextColor());
                }
                SwingUtilities2.drawStringUnderlineCharAt(c, g2, text, mnemIndex, textRect.x, textRect.y + fm.getAscent());
            }
        }
    }

    @Override
    public Icon getDefaultIcon() {
        return new IconUIResource(EmptyIcon.create(20));
    }
}

