/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula.ui;

import com.bulenkov.iconloader.util.DoubleColor;
import com.bulenkov.iconloader.util.GraphicsUtil;
import com.bulenkov.iconloader.util.Gray;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JComponent;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicProgressBarUI;
import sun.swing.SwingUtilities2;

public class DarculaProgressBarUI
extends BasicProgressBarUI {
    protected volatile int offset = 0;

    public static ComponentUI createUI(JComponent c) {
        c.setBorder(new BorderUIResource(new EmptyBorder(0, 0, 0, 0)));
        return new DarculaProgressBarUI();
    }

    @Override
    protected void paintIndeterminate(Graphics g2, JComponent c) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Insets b = this.progressBar.getInsets();
        int barRectWidth = this.progressBar.getWidth() - (b.right + b.left);
        int barRectHeight = this.progressBar.getHeight() - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        g2.setColor(new DoubleColor(Gray._240, Gray._128));
        int w = c.getWidth();
        int h2 = c.getPreferredSize().height;
        g2.fillRect(0, (c.getHeight() - h2) / 2, w, h2);
        g2.setColor(new DoubleColor(Gray._165, Gray._88));
        GraphicsUtil.setupAAPainting(g2);
        Path2D.Double path = new Path2D.Double();
        int ww = this.getPeriodLength() / 2;
        g2.translate(0, (c.getHeight() - h2) / 2);
        path.moveTo(0.0, 0.0);
        path.lineTo(ww, 0.0);
        path.lineTo(ww - h2 / 2, h2);
        path.lineTo(-h2 / 2, h2);
        path.lineTo(0.0, 0.0);
        path.closePath();
        for (int x = -this.offset; x < Math.max(c.getWidth(), c.getHeight()); x += this.getPeriodLength()) {
            g2.translate(x, 0);
            ((Graphics2D)g2).fill(path);
            g2.translate(-x, 0);
        }
        this.offset = (this.offset + 1) % this.getPeriodLength();
        Area area = new Area(new Rectangle2D.Double(0.0, 0.0, w, h2));
        area.subtract(new Area(new RoundRectangle2D.Double(1.0, 1.0, w - 2, h2 - 2, 8.0, 8.0)));
        ((Graphics2D)g2).setPaint(Gray._128);
        ((Graphics2D)g2).fill(area);
        area.subtract(new Area(new RoundRectangle2D.Double(0.0, 0.0, w, h2, 9.0, 9.0)));
        ((Graphics2D)g2).setPaint(c.getParent().getBackground());
        ((Graphics2D)g2).fill(area);
        g2.drawRoundRect(1, 1, w - 3, h2 - 3, 8, 8);
        g2.translate(0, -(c.getHeight() - h2) / 2);
        if (this.progressBar.isStringPainted()) {
            if (this.progressBar.getOrientation() == 0) {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.x, this.boxRect.width);
            } else {
                this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, this.boxRect.y, this.boxRect.height);
            }
        }
    }

    @Override
    protected void paintDeterminate(Graphics g2, JComponent c) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        if (this.progressBar.getOrientation() != 0 || !c.getComponentOrientation().isLeftToRight()) {
            super.paintDeterminate(g2, c);
            return;
        }
        GraphicsUtil.setupAAPainting(g2);
        Insets b = this.progressBar.getInsets();
        int w = this.progressBar.getWidth();
        int h2 = this.progressBar.getPreferredSize().height;
        int barRectWidth = w - (b.right + b.left);
        int barRectHeight = h2 - (b.top + b.bottom);
        if (barRectWidth <= 0 || barRectHeight <= 0) {
            return;
        }
        int amountFull = this.getAmountFull(b, barRectWidth, barRectHeight);
        g2.setColor(c.getParent().getBackground());
        Graphics2D g22 = (Graphics2D)g2;
        g2.fillRect(0, 0, w, h2);
        g22.translate(0, (c.getHeight() - h2) / 2);
        g22.setColor(this.progressBar.getForeground());
        g22.fill(new RoundRectangle2D.Double(0.0, 0.0, w - 1, h2 - 1, 9.0, 9.0));
        g22.setColor(c.getParent().getBackground());
        g22.fill(new RoundRectangle2D.Double(1.0, 1.0, w - 3, h2 - 3, 8.0, 8.0));
        g22.setColor(this.progressBar.getForeground());
        g22.fill(new RoundRectangle2D.Double(2.0, 2.0, amountFull - 5, h2 - 5, 7.0, 7.0));
        g22.translate(0, -(c.getHeight() - h2) / 2);
        if (this.progressBar.isStringPainted()) {
            this.paintString(g2, b.left, b.top, barRectWidth, barRectHeight, amountFull, b);
        }
    }

    private void paintString(Graphics g2, int x, int y, int w, int h2, int fillStart, int amountFull) {
        if (!(g2 instanceof Graphics2D)) {
            return;
        }
        Graphics2D g22 = (Graphics2D)g2;
        String progressString = this.progressBar.getString();
        g22.setFont(this.progressBar.getFont());
        Point renderLocation = this.getStringPlacement(g22, progressString, x, y, w, h2);
        Rectangle oldClip = g22.getClipBounds();
        if (this.progressBar.getOrientation() == 0) {
            g22.setColor(this.getSelectionBackground());
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(fillStart, y, amountFull, h2);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
        } else {
            g22.setColor(this.getSelectionBackground());
            AffineTransform rotate = AffineTransform.getRotateInstance(1.5707963267948966);
            g22.setFont(this.progressBar.getFont().deriveFont(rotate));
            renderLocation = this.getStringPlacement(g22, progressString, x, y, w, h2);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
            g22.setColor(this.getSelectionForeground());
            g22.clipRect(x, fillStart, w, amountFull);
            SwingUtilities2.drawString((JComponent)this.progressBar, (Graphics)g22, progressString, renderLocation.x, renderLocation.y);
        }
        g22.setClip(oldClip);
    }

    @Override
    protected int getBoxLength(int availableLength, int otherDimension) {
        return availableLength;
    }

    protected int getPeriodLength() {
        return 16;
    }
}

