/*
 * Decompiled with CFR 0.152.
 */
package com.bulenkov.darcula;

import com.bulenkov.darcula.DarculaMetalTheme;
import com.bulenkov.iconloader.IconLoader;
import com.bulenkov.iconloader.util.ColorUtil;
import com.bulenkov.iconloader.util.EmptyIcon;
import com.bulenkov.iconloader.util.StringUtil;
import com.bulenkov.iconloader.util.SystemInfo;
import com.bulenkov.iconloader.util.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.IconUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DarculaLaf
extends BasicLookAndFeel {
    public static final String NAME = "Darcula";
    BasicLookAndFeel base;
    private static final boolean isMacOSYosemite = SystemInfo.compareVersionNumbers(SystemInfo.OS_VERSION, "10.9.9") == 1;
    private static final boolean isMacOSElCapitan = isMacOSYosemite && !SystemInfo.OS_VERSION.startsWith("10.10");
    @NonNls
    private static final String[] ourPatchableFontResources = new String[]{"Button.font", "ToggleButton.font", "RadioButton.font", "CheckBox.font", "ColorChooser.font", "ComboBox.font", "Label.font", "List.font", "MenuBar.font", "MenuItem.font", "MenuItem.acceleratorFont", "RadioButtonMenuItem.font", "CheckBoxMenuItem.font", "Menu.font", "PopupMenu.font", "OptionPane.font", "Panel.font", "ProgressBar.font", "ScrollPane.font", "Viewport.font", "TabbedPane.font", "Table.font", "TableHeader.font", "TextField.font", "FormattedTextField.font", "Spinner.font", "PasswordField.font", "TextArea.font", "TextPane.font", "EditorPane.font", "TitledBorder.font", "ToolBar.font", "ToolTip.font", "Tree.font"};

    public DarculaLaf() {
        try {
            if (SystemInfo.isWindows || SystemInfo.isLinux) {
                this.base = new MetalLookAndFeel();
                MetalLookAndFeel.setCurrentTheme(new DarculaMetalTheme());
            } else {
                String name = UIManager.getSystemLookAndFeelClassName();
                this.base = (BasicLookAndFeel)Class.forName(name).newInstance();
            }
            UIUtil.initSystemFontData();
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    private void callInit(String method, UIDefaults defaults) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, UIDefaults.class);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    private static void log(Exception e) {
    }

    public static boolean isDialogFont(@NotNull Font font) {
        if (font == null) {
            DarculaLaf.$$$reportNull$$$0(0);
        }
        return "Dialog".equals(font.getFamily(Locale.US));
    }

    @NotNull
    private static FontUIResource getFont(String yosemite, int size, @JdkConstants.FontStyle int style) {
        Font font;
        if (isMacOSElCapitan) {
            Font font2 = new Font(".SF NS Text", style, size);
            if (!DarculaLaf.isDialogFont(font2)) {
                return new FontUIResource(font2);
            }
            font2 = new Font(".SFNS-Regular", style, size);
            if (!DarculaLaf.isDialogFont(font2)) {
                return new FontUIResource(font2);
            }
        } else if (SystemInfo.isWindows && !DarculaLaf.isDialogFont(font = (Font)Toolkit.getDefaultToolkit().getDesktopProperty("win.messagebox.font"))) {
            return new FontUIResource(font);
        }
        return new FontUIResource(yosemite, style, size);
    }

    public static void initFontDefaults(@NotNull UIDefaults defaults, @NotNull FontUIResource uiFont) {
        if (defaults == null) {
            DarculaLaf.$$$reportNull$$$0(1);
        }
        if (uiFont == null) {
            DarculaLaf.$$$reportNull$$$0(2);
        }
        defaults.put("Tree.ancestorInputMap", (Object)null);
        FontUIResource textFont = new FontUIResource(uiFont);
        FontUIResource monoFont = new FontUIResource("Monospaced", 0, uiFont.getSize());
        for (String fontResource : ourPatchableFontResources) {
            defaults.put(fontResource, uiFont);
        }
        if (!SystemInfo.isMac) {
            defaults.put("PasswordField.font", monoFont);
        }
        defaults.put("TextArea.font", monoFont);
        defaults.put("TextPane.font", textFont);
        defaults.put("EditorPane.font", textFont);
    }

    public static void installMacOSXFonts(UIDefaults defaults) {
        String face = ".Helvetica Neue DeskInterface";
        FontUIResource uiFont = DarculaLaf.getFont(".Helvetica Neue DeskInterface", 13, 0);
        DarculaLaf.initFontDefaults(defaults, uiFont);
        for (Object key : new HashSet(defaults.keySet())) {
            FontUIResource font;
            Object value = defaults.get(key);
            if (!(value instanceof FontUIResource) || !(font = (FontUIResource)value).getFamily().equals("Lucida Grande") && !font.getFamily().equals("Serif") || key.toString().contains("Menu")) continue;
            defaults.put(key, DarculaLaf.getFont(".Helvetica Neue DeskInterface", font.getSize(), font.getStyle()));
        }
        FontUIResource uiFont11 = DarculaLaf.getFont(".Helvetica Neue DeskInterface", 11, 0);
        defaults.put("TableHeader.font", uiFont11);
        FontUIResource buttonFont = DarculaLaf.getFont("HelveticaNeue-Medium", 13, 0);
        defaults.put("Button.font", buttonFont);
        FontUIResource menuFont = DarculaLaf.getFont("Lucida Grande", 14, 0);
        defaults.put("Menu.font", menuFont);
        defaults.put("MenuItem.font", menuFont);
        defaults.put("MenuItem.acceleratorFont", menuFont);
        defaults.put("PasswordField.font", defaults.getFont("TextField.font"));
    }

    @Override
    public UIDefaults getDefaults() {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("getDefaults", new Class[0]);
            superMethod.setAccessible(true);
            UIDefaults metalDefaults = (UIDefaults)superMethod.invoke((Object)new MetalLookAndFeel(), new Object[0]);
            UIDefaults defaults = (UIDefaults)superMethod.invoke((Object)this.base, new Object[0]);
            DarculaLaf.initInputMapDefaults(defaults);
            DarculaLaf.initIdeaDefaults(defaults);
            DarculaLaf.patchStyledEditorKit();
            DarculaLaf.patchComboBox(metalDefaults, defaults);
            defaults.remove("Spinner.arrowButtonBorder");
            defaults.put("Spinner.arrowButtonSize", new Dimension(16, 5));
            defaults.put("Tree.collapsedIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/treeNodeCollapsed.png")));
            defaults.put("Tree.expandedIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/treeNodeExpanded.png")));
            defaults.put("Menu.arrowIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/menuItemArrowIcon.png")));
            defaults.put("CheckBoxMenuItem.checkIcon", EmptyIcon.create(16));
            defaults.put("RadioButtonMenuItem.checkIcon", EmptyIcon.create(16));
            defaults.put("InternalFrame.icon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/internalFrame.png")));
            defaults.put("OptionPane.informationIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/option_pane_info.png")));
            defaults.put("OptionPane.questionIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/option_pane_question.png")));
            defaults.put("OptionPane.warningIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/option_pane_warning.png")));
            defaults.put("OptionPane.errorIcon", new IconUIResource(IconLoader.getIcon("/com/bulenkov/darcula/icons/option_pane_error.png")));
            defaults.put("TitledBorder.border", new BorderUIResource.LineBorderUIResource(new ColorUIResource(107, 107, 107)));
            BorderUIResource.EmptyBorderUIResource empty1PixelBorder = new BorderUIResource.EmptyBorderUIResource(1, 1, 1, 1);
            defaults.put("Table.focusCellHighlightBorder", empty1PixelBorder);
            defaults.put("Table.cellNoFocusBorder", empty1PixelBorder);
            defaults.put("List.focusCellHighlightBorder", empty1PixelBorder);
            defaults.put("List.cellNoFocusBorder", empty1PixelBorder);
            defaults.put("Tree.selectionBorderColor", (Object)null);
            if (SystemInfo.isWindows || isMacOSYosemite) {
                DarculaLaf.installMacOSXFonts(defaults);
            }
            if (SystemInfo.isMac && !"true".equalsIgnoreCase(System.getProperty("apple.laf.useScreenMenuBar", "false"))) {
                defaults.put("MenuBarUI", "com.bulenkov.darcula.ui.DarculaMenuBarUI");
                defaults.put("MenuUI", "javax.swing.plaf.basic.BasicMenuUI");
            }
            return defaults;
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
            return super.getDefaults();
        }
    }

    private static void patchComboBox(UIDefaults metalDefaults, UIDefaults defaults) {
        defaults.remove("ComboBox.ancestorInputMap");
        defaults.remove("ComboBox.actionMap");
        defaults.put("ComboBox.ancestorInputMap", metalDefaults.get("ComboBox.ancestorInputMap"));
        defaults.put("ComboBox.actionMap", metalDefaults.get("ComboBox.actionMap"));
    }

    private static void patchStyledEditorKit() {
        StyleSheet defaultStyles = new StyleSheet();
        try {
            InputStream is = DarculaLaf.class.getResourceAsStream("darcula.css");
            BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            defaultStyles.loadRules(r, null);
            ((Reader)r).close();
            new HTMLEditorKit().setStyleSheet(defaultStyles);
        }
        catch (Exception e) {
            DarculaLaf.log(e);
        }
    }

    private void call(String method) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod(method, new Class[0]);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, new Object[0]);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public void initComponentDefaults(UIDefaults defaults) {
        System.out.println("In initComponentDefaults");
        this.callInit("initComponentDefaults", defaults);
    }

    static void initIdeaDefaults(UIDefaults defaults) {
        DarculaLaf.loadDefaults(defaults);
        defaults.put("Table.ancestorInputMap", new UIDefaults.LazyInputMap(new Object[]{"ctrl C", "copy", "ctrl V", "paste", "ctrl X", "cut", "COPY", "copy", "PASTE", "paste", "CUT", "cut", "control INSERT", "copy", "shift INSERT", "paste", "shift DELETE", "cut", "RIGHT", "selectNextColumn", "KP_RIGHT", "selectNextColumn", "LEFT", "selectPreviousColumn", "KP_LEFT", "selectPreviousColumn", "DOWN", "selectNextRow", "KP_DOWN", "selectNextRow", "UP", "selectPreviousRow", "KP_UP", "selectPreviousRow", "shift RIGHT", "selectNextColumnExtendSelection", "shift KP_RIGHT", "selectNextColumnExtendSelection", "shift LEFT", "selectPreviousColumnExtendSelection", "shift KP_LEFT", "selectPreviousColumnExtendSelection", "shift DOWN", "selectNextRowExtendSelection", "shift KP_DOWN", "selectNextRowExtendSelection", "shift UP", "selectPreviousRowExtendSelection", "shift KP_UP", "selectPreviousRowExtendSelection", "PAGE_UP", "scrollUpChangeSelection", "PAGE_DOWN", "scrollDownChangeSelection", "HOME", "selectFirstColumn", "END", "selectLastColumn", "shift PAGE_UP", "scrollUpExtendSelection", "shift PAGE_DOWN", "scrollDownExtendSelection", "shift HOME", "selectFirstColumnExtendSelection", "shift END", "selectLastColumnExtendSelection", "ctrl PAGE_UP", "scrollLeftChangeSelection", "ctrl PAGE_DOWN", "scrollRightChangeSelection", "ctrl HOME", "selectFirstRow", "ctrl END", "selectLastRow", "ctrl shift PAGE_UP", "scrollRightExtendSelection", "ctrl shift PAGE_DOWN", "scrollLeftExtendSelection", "ctrl shift HOME", "selectFirstRowExtendSelection", "ctrl shift END", "selectLastRowExtendSelection", "TAB", "selectNextColumnCell", "shift TAB", "selectPreviousColumnCell", "shift ENTER", "selectPreviousRowCell", "ctrl A", "selectAll", "meta A", "selectAll", "F2", "startEditing"}));
    }

    private static void loadDefaults(UIDefaults defaults) {
        Properties properties = new Properties();
        String osSuffix = SystemInfo.isMac ? "mac" : (SystemInfo.isWindows ? "windows" : "linux");
        try {
            InputStream stream = DarculaLaf.class.getResourceAsStream("darcula.properties");
            properties.load(stream);
            stream.close();
            stream = DarculaLaf.class.getResourceAsStream("darcula_" + osSuffix + ".properties");
            properties.load(stream);
            stream.close();
            HashMap<String, Object> darculaGlobalSettings = new HashMap<String, Object>();
            String prefix = "darcula.";
            for (String key : properties.stringPropertyNames()) {
                if (!key.startsWith("darcula.")) continue;
                darculaGlobalSettings.put(key.substring("darcula.".length()), DarculaLaf.parseValue(key, properties.getProperty(key)));
            }
            for (String key : defaults.keySet()) {
                String s2;
                String darculaKey;
                if (!(key instanceof String) || !key.contains(".") || !darculaGlobalSettings.containsKey(darculaKey = (s2 = key).substring(s2.lastIndexOf(46) + 1))) continue;
                defaults.put(key, darculaGlobalSettings.get(darculaKey));
            }
            for (String key : properties.stringPropertyNames()) {
                String value = properties.getProperty(key);
                defaults.put(key, DarculaLaf.parseValue(key, value));
            }
        }
        catch (IOException e) {
            DarculaLaf.log(e);
        }
    }

    private static Object parseValue(String key, String value) {
        if ("null".equals(value)) {
            return null;
        }
        if (key.endsWith(".margin") || key.endsWith("Insets")) {
            List<String> numbers = StringUtil.split(value, ",");
            return new InsetsUIResource(Integer.parseInt(numbers.get(0)), Integer.parseInt(numbers.get(1)), Integer.parseInt(numbers.get(2)), Integer.parseInt(numbers.get(3)));
        }
        if (key.endsWith(".border") || key.endsWith("Border")) {
            try {
                return Class.forName(value).newInstance();
            }
            catch (Exception e) {
                DarculaLaf.log(e);
            }
        } else {
            Icon icon;
            Color color = ColorUtil.fromHex(value, null);
            Integer invVal = DarculaLaf.getInteger(value);
            Boolean boolVal = "true".equals(value) ? Boolean.TRUE : ("false".equals(value) ? Boolean.FALSE : null);
            Icon icon2 = icon = key.toLowerCase().endsWith("icon") ? null : null;
            if (color != null) {
                return new ColorUIResource(color);
            }
            if (invVal != null) {
                return invVal;
            }
            if (icon != null) {
                return new IconUIResource(icon);
            }
            if (boolVal != null) {
                return boolVal;
            }
        }
        return value;
    }

    private static Integer getInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getID() {
        return this.getName();
    }

    @Override
    public String getDescription() {
        return "IntelliJ Dark Look and Feel";
    }

    @Override
    public boolean isNativeLookAndFeel() {
        return true;
    }

    @Override
    public boolean isSupportedLookAndFeel() {
        return true;
    }

    @Override
    protected void initSystemColorDefaults(UIDefaults defaults) {
        this.callInit("initSystemColorDefaults", defaults);
    }

    @Override
    protected void initClassDefaults(UIDefaults defaults) {
        this.callInit("initClassDefaults", defaults);
    }

    @Override
    public void initialize() {
        this.call("initialize");
    }

    @Override
    public void uninitialize() {
        this.call("uninitialize");
    }

    @Override
    protected void loadSystemColors(UIDefaults defaults, String[] systemColors, boolean useNative) {
        try {
            Method superMethod = BasicLookAndFeel.class.getDeclaredMethod("loadSystemColors", UIDefaults.class, String[].class, Boolean.TYPE);
            superMethod.setAccessible(true);
            superMethod.invoke((Object)this.base, defaults, systemColors, useNative);
        }
        catch (Exception ignore) {
            DarculaLaf.log(ignore);
        }
    }

    @Override
    public boolean getSupportsWindowDecorations() {
        return true;
    }

    public static void initInputMapDefaults(UIDefaults defaults) {
        InputMap tableInputMap;
        InputMap passwordFieldInputMap;
        InputMap textFieldInputMap;
        InputMap textAreaInputMap;
        InputMap treeInputMap = (InputMap)defaults.get("Tree.focusInputMap");
        if (treeInputMap != null) {
            treeInputMap.put(KeyStroke.getKeyStroke(10, 0), "toggle");
        }
        if ((textAreaInputMap = (InputMap)defaults.get("TextArea.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(textAreaInputMap, false);
        }
        if ((textFieldInputMap = (InputMap)defaults.get("TextField.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(textFieldInputMap, false);
        }
        if ((passwordFieldInputMap = (InputMap)defaults.get("PasswordField.focusInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(passwordFieldInputMap, false);
        }
        if ((tableInputMap = (InputMap)defaults.get("Table.ancestorInputMap")) != null) {
            DarculaLaf.installCutCopyPasteShortcuts(tableInputMap, true);
        }
    }

    private static void installCutCopyPasteShortcuts(InputMap inputMap, boolean useSimpleActionKeys) {
        String copyActionKey = useSimpleActionKeys ? "copy" : "copy-to-clipboard";
        String pasteActionKey = useSimpleActionKeys ? "paste" : "paste-from-clipboard";
        String cutActionKey = useSimpleActionKeys ? "cut" : "cut-to-clipboard";
        inputMap.put(KeyStroke.getKeyStroke(155, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(155, 65), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(127, 65), cutActionKey);
        inputMap.put(KeyStroke.getKeyStroke(67, 130), copyActionKey);
        inputMap.put(KeyStroke.getKeyStroke(86, 130), pasteActionKey);
        inputMap.put(KeyStroke.getKeyStroke(88, 130), "cut-to-clipboard");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "font";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaults";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiFont";
                break;
            }
        }
        objectArray2[1] = "com/bulenkov/darcula/DarculaLaf";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isDialogFont";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "initFontDefaults";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

