/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.highlight;

import cuchaz.enigma.config.Config;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class BoxHighlightPainter
implements Highlighter.HighlightPainter {
    private Color fillColor;
    private Color borderColor;

    protected BoxHighlightPainter(Color fillColor, Color borderColor) {
        this.fillColor = fillColor;
        this.borderColor = borderColor;
    }

    public static BoxHighlightPainter create(Config.AlphaColorEntry entry, Config.AlphaColorEntry entryOutline) {
        return new BoxHighlightPainter(entry != null ? entry.get() : null, entryOutline != null ? entryOutline.get() : null);
    }

    public static Rectangle getBounds(JTextComponent text, int start, int end) {
        try {
            Rectangle startRect = text.modelToView(start);
            Rectangle endRect = text.modelToView(end);
            Rectangle bounds = startRect.union(endRect);
            bounds.x -= 2;
            bounds.width += 2;
            ++bounds.y;
            bounds.height -= 2;
            return bounds;
        }
        catch (BadLocationException ex) {
            return new Rectangle(0, 0, 0, 0);
        }
    }

    @Override
    public void paint(Graphics g, int start, int end, Shape shape, JTextComponent text) {
        Rectangle bounds = BoxHighlightPainter.getBounds(text, start, end);
        if (this.fillColor != null) {
            g.setColor(this.fillColor);
            g.fillRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
        }
        g.setColor(this.borderColor);
        g.drawRoundRect(bounds.x, bounds.y, bounds.width, bounds.height, 4, 4);
    }
}

