/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.dialog;

import cuchaz.enigma.utils.I18n;
import cuchaz.enigma.utils.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class JavadocDialog {
    private static JavadocDialog instance = null;
    private JFrame frame = new JFrame(I18n.translate("javadocs.edit"));

    private JavadocDialog(JFrame parent, JTextArea text, final Callback callback) {
        Container pane = this.frame.getContentPane();
        pane.setLayout(new BorderLayout());
        text.setTabSize(2);
        pane.add((Component)new JScrollPane(text), "Center");
        text.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent event) {
                switch (event.getKeyCode()) {
                    case 10: {
                        if (!event.isControlDown()) break;
                        callback.closeUi(JavadocDialog.this.frame, true);
                        break;
                    }
                    case 27: {
                        callback.closeUi(JavadocDialog.this.frame, false);
                        break;
                    }
                }
            }
        });
        JPanel buttonsPanel = new JPanel();
        FlowLayout buttonsLayout = new FlowLayout();
        buttonsLayout.setAlignment(2);
        buttonsPanel.setLayout(buttonsLayout);
        buttonsPanel.add(Utils.unboldLabel(new JLabel(I18n.translate("javadocs.instruction"))));
        JButton cancelButton = new JButton(I18n.translate("javadocs.cancel"));
        cancelButton.addActionListener(event -> callback.closeUi(this.frame, false));
        buttonsPanel.add(cancelButton);
        JButton saveButton = new JButton(I18n.translate("javadocs.save"));
        saveButton.addActionListener(event -> callback.closeUi(this.frame, true));
        buttonsPanel.add(saveButton);
        pane.add((Component)buttonsPanel, "South");
        this.frame.setSize(600, 400);
        this.frame.setLocationRelativeTo(parent);
        this.frame.setDefaultCloseOperation(2);
    }

    public static void init(JFrame parent, JTextArea area, Callback callback) {
        instance = new JavadocDialog(parent, area, callback);
        JavadocDialog.instance.frame.doLayout();
        JavadocDialog.instance.frame.setVisible(true);
    }

    public static interface Callback {
        public void closeUi(JFrame var1, boolean var2);
    }
}

