/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.GuiController;
import cuchaz.enigma.gui.node.ClassSelectorClassNode;
import cuchaz.enigma.gui.node.ClassSelectorPackageNode;
import cuchaz.enigma.throwables.IllegalNameException;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassSelector
extends JTree {
    public static final Comparator<ClassEntry> DEOBF_CLASS_COMPARATOR = Comparator.comparing(ClassEntry::getFullName);
    private final GuiController controller;
    private DefaultMutableTreeNode rootNodes;
    private ClassSelectionListener selectionListener;
    private RenameSelectionListener renameSelectionListener;
    private Comparator<ClassEntry> comparator;
    private final Map<ClassEntry, ClassEntry> displayedObfToDeobf = new HashMap<ClassEntry, ClassEntry>();

    public ClassSelector(final Gui gui, Comparator<ClassEntry> comparator, final boolean isRenamable) {
        this.comparator = comparator;
        this.controller = gui.getController();
        this.setEditable(true);
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setModel(null);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                TreePath path;
                if (ClassSelector.this.selectionListener != null && event.getClickCount() == 2 && (path = ClassSelector.this.getSelectionPath()) != null && path.getLastPathComponent() instanceof ClassSelectorClassNode) {
                    ClassSelectorClassNode node = (ClassSelectorClassNode)path.getLastPathComponent();
                    ClassSelector.this.selectionListener.onSelectClass(node.getObfEntry());
                }
            }
        });
        ClassSelector tree = this;
        final DefaultTreeCellEditor editor = new DefaultTreeCellEditor(tree, (DefaultTreeCellRenderer)tree.getCellRenderer()){

            @Override
            public boolean isCellEditable(EventObject event) {
                return isRenamable && !(event instanceof MouseEvent) && super.isCellEditable(event);
            }
        };
        this.setCellEditor(editor);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                String data = editor.getCellEditorValue().toString();
                TreePath path = ClassSelector.this.getSelectionPath();
                Object realPath = path.getLastPathComponent();
                if (realPath != null && realPath instanceof DefaultMutableTreeNode && data != null) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)realPath;
                    TreeNode parentNode = node.getParent();
                    if (parentNode == null) {
                        return;
                    }
                    boolean allowEdit = true;
                    for (int i = 0; i < parentNode.getChildCount(); ++i) {
                        TreeNode childNode = parentNode.getChildAt(i);
                        if (childNode == null || !childNode.toString().equals(data) || childNode == node) continue;
                        allowEdit = false;
                        break;
                    }
                    if (allowEdit && ClassSelector.this.renameSelectionListener != null) {
                        Object prevData = node.getUserObject();
                        Object objectData = node.getUserObject() instanceof ClassEntry ? new ClassEntry(((ClassEntry)prevData).getPackageName() + "/" + data) : data;
                        try {
                            ClassSelector.this.renameSelectionListener.onSelectionRename(node.getUserObject(), objectData, node);
                            node.setUserObject(objectData);
                        }
                        catch (IllegalNameException ex) {
                            JOptionPane.showOptionDialog(gui.getFrame(), ex.getMessage(), "Enigma - Error", 0, 0, null, new String[]{"Ok"}, "OK");
                            editor.cancelCellEditing();
                        }
                    } else {
                        editor.cancelCellEditing();
                    }
                }
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.selectionListener = null;
        this.renameSelectionListener = null;
    }

    public boolean isDuplicate(Object[] nodes, String data) {
        int count = 0;
        for (Object node : nodes) {
            if (!node.toString().equals(data) || ++count != 2) continue;
            return true;
        }
        return false;
    }

    public void setSelectionListener(ClassSelectionListener val) {
        this.selectionListener = val;
    }

    public void setRenameSelectionListener(RenameSelectionListener renameSelectionListener) {
        this.renameSelectionListener = renameSelectionListener;
    }

    public void setClasses(Collection<ClassEntry> classEntries) {
        this.displayedObfToDeobf.clear();
        List<StateEntry> state = this.getExpansionState(this);
        if (classEntries == null) {
            this.setModel(null);
            return;
        }
        Translator translator = this.controller.project.getMapper().getDeobfuscator();
        HashMap packages = Maps.newHashMap();
        for (ClassEntry classEntry : classEntries) {
            ClassEntry deobfClass = translator.translate(classEntry);
            packages.put(deobfClass.getPackageName(), null);
        }
        ArrayList sortedPackageNames = Lists.newArrayList(packages.keySet());
        sortedPackageNames.sort((a, b) -> {
            if (b == null || a == null) {
                return 0;
            }
            String[] aparts = a.split("/");
            String[] bparts = b.split("/");
            int i = 0;
            while (i < aparts.length) {
                if (i >= bparts.length) {
                    return 1;
                }
                int result = aparts[i].compareTo(bparts[i]);
                if (result != 0) {
                    return result;
                }
                ++i;
            }
            return -1;
        });
        this.rootNodes = new DefaultMutableTreeNode();
        for (String packageName : sortedPackageNames) {
            ClassSelectorPackageNode node = new ClassSelectorPackageNode(packageName);
            packages.put(packageName, node);
            this.rootNodes.add(node);
        }
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (ClassEntry obfClass : classEntries) {
            ClassEntry deobfClass = translator.translate(obfClass);
            arrayListMultimap.put((Object)deobfClass.getPackageName(), (Object)obfClass);
        }
        for (String packageName : arrayListMultimap.keySet()) {
            ArrayList classEntriesInPackage = Lists.newArrayList((Iterable)arrayListMultimap.get((Object)packageName));
            classEntriesInPackage.sort((o1, o2) -> this.comparator.compare(translator.translate(o1), translator.translate(o2)));
            for (ClassEntry obfClass : classEntriesInPackage) {
                ClassEntry deobfClass = translator.translate(obfClass);
                ClassSelectorPackageNode node = (ClassSelectorPackageNode)packages.get(packageName);
                ClassSelectorClassNode classNode = new ClassSelectorClassNode(obfClass, deobfClass);
                this.displayedObfToDeobf.put(obfClass, deobfClass);
                node.add(classNode);
            }
        }
        this.setModel(new DefaultTreeModel(this.rootNodes));
        this.restoreExpansionState(this, state);
    }

    public ClassEntry getSelectedClass() {
        Object selectedNode;
        if (!this.isSelectionEmpty() && (selectedNode = this.getSelectionPath().getLastPathComponent()) instanceof ClassSelectorClassNode) {
            ClassSelectorClassNode classNode = (ClassSelectorClassNode)selectedNode;
            return classNode.getClassEntry();
        }
        return null;
    }

    public String getSelectedPackage() {
        if (!this.isSelectionEmpty()) {
            Object selectedNode = this.getSelectionPath().getLastPathComponent();
            if (selectedNode instanceof ClassSelectorPackageNode) {
                ClassSelectorPackageNode packageNode = (ClassSelectorPackageNode)selectedNode;
                return packageNode.getPackageName();
            }
            if (selectedNode instanceof ClassSelectorClassNode) {
                ClassSelectorClassNode classNode = (ClassSelectorClassNode)selectedNode;
                return classNode.getClassEntry().getPackageName();
            }
        }
        return null;
    }

    public boolean isDescendant(TreePath path1, TreePath path2) {
        int count2;
        int count1 = path1.getPathCount();
        if (count1 <= (count2 = path2.getPathCount())) {
            return false;
        }
        while (count1 != count2) {
            path1 = path1.getParentPath();
            --count1;
        }
        return path1.equals(path2);
    }

    public List<StateEntry> getExpansionState(JTree tree) {
        ArrayList<StateEntry> state = new ArrayList<StateEntry>();
        int rowCount = tree.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            TreePath path = tree.getPathForRow(i);
            if (tree.isPathSelected(path)) {
                state.add(new StateEntry(State.SELECTED, path));
            }
            if (!tree.isExpanded(path)) continue;
            state.add(new StateEntry(State.EXPANDED, path));
        }
        return state;
    }

    public void restoreExpansionState(JTree tree, List<StateEntry> expansionState) {
        tree.clearSelection();
        for (StateEntry entry : expansionState) {
            switch (entry.state) {
                case SELECTED: {
                    tree.addSelectionPath(entry.path);
                    break;
                }
                case EXPANDED: {
                    tree.expandPath(entry.path);
                }
            }
        }
    }

    public List<ClassSelectorPackageNode> packageNodes() {
        ArrayList nodes = Lists.newArrayList();
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.getModel().getRoot();
        Enumeration<TreeNode> children = root.children();
        while (children.hasMoreElements()) {
            ClassSelectorPackageNode packageNode = (ClassSelectorPackageNode)children.nextElement();
            nodes.add(packageNode);
        }
        return nodes;
    }

    public List<ClassSelectorClassNode> classNodes(ClassSelectorPackageNode packageNode) {
        ArrayList nodes = Lists.newArrayList();
        Enumeration<TreeNode> children = packageNode.children();
        while (children.hasMoreElements()) {
            ClassSelectorClassNode classNode = (ClassSelectorClassNode)children.nextElement();
            nodes.add(classNode);
        }
        return nodes;
    }

    public void expandPackage(String packageName) {
        if (packageName == null) {
            return;
        }
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            if (!packageNode.getPackageName().equals(packageName)) continue;
            this.expandPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode}));
            return;
        }
    }

    public void expandAll() {
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            this.expandPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode}));
        }
    }

    public ClassEntry getFirstClass() {
        ClassSelectorClassNode classNode;
        ClassSelectorPackageNode packageNode = this.packageNodes().get(0);
        if (packageNode != null && (classNode = this.classNodes(packageNode).get(0)) != null) {
            return classNode.getClassEntry();
        }
        return null;
    }

    public ClassSelectorPackageNode getPackageNode(ClassEntry entry) {
        String packageName = entry.getPackageName();
        if (packageName == null) {
            packageName = "(none)";
        }
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            if (!packageNode.getPackageName().equals(packageName)) continue;
            return packageNode;
        }
        return null;
    }

    @Nullable
    public ClassEntry getDisplayedDeobf(ClassEntry obfEntry) {
        return this.displayedObfToDeobf.get(obfEntry);
    }

    public ClassSelectorPackageNode getPackageNode(ClassSelector selector, ClassEntry entry) {
        ClassSelectorPackageNode packageNode = this.getPackageNode(entry);
        if (selector != null && packageNode == null && selector.getPackageNode(entry) != null) {
            return selector.getPackageNode(entry);
        }
        return packageNode;
    }

    public ClassEntry getNextClass(ClassEntry entry) {
        boolean foundIt = false;
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            if (!foundIt) {
                if (!packageNode.getPackageName().equals(entry.getPackageName())) continue;
                for (ClassSelectorClassNode classNode : this.classNodes(packageNode)) {
                    if (!foundIt) {
                        if (!classNode.getClassEntry().equals(entry)) continue;
                        foundIt = true;
                        continue;
                    }
                    return classNode.getClassEntry();
                }
                continue;
            }
            ClassSelectorClassNode classNode = this.classNodes(packageNode).get(0);
            if (classNode == null) continue;
            return classNode.getClassEntry();
        }
        return null;
    }

    public void setSelectionClass(ClassEntry classEntry) {
        this.expandPackage(classEntry.getPackageName());
        for (ClassSelectorPackageNode packageNode : this.packageNodes()) {
            for (ClassSelectorClassNode classNode : this.classNodes(packageNode)) {
                if (!classNode.getClassEntry().equals(classEntry)) continue;
                this.setSelectionPath(new TreePath(new Object[]{this.getModel().getRoot(), packageNode, classNode}));
            }
        }
    }

    public void removeNode(ClassSelectorPackageNode packageNode, ClassEntry entry) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        if (packageNode == null) {
            return;
        }
        for (int i = 0; i < packageNode.getChildCount(); ++i) {
            DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)packageNode.getChildAt(i);
            if (!(childNode.getUserObject() instanceof ClassEntry) || !childNode.getUserObject().equals(entry)) continue;
            model.removeNodeFromParent(childNode);
            if (!(childNode instanceof ClassSelectorClassNode)) break;
            this.displayedObfToDeobf.remove(((ClassSelectorClassNode)childNode).getObfEntry());
            break;
        }
    }

    public void removeNodeIfEmpty(ClassSelectorPackageNode packageNode) {
        if (packageNode != null && packageNode.getChildCount() == 0) {
            ((DefaultTreeModel)this.getModel()).removeNodeFromParent(packageNode);
        }
    }

    public void moveClassIn(ClassEntry classEntry) {
        this.removeEntry(classEntry);
        this.insertNode(classEntry);
    }

    public void moveClassOut(ClassEntry classEntry) {
        this.removeEntry(classEntry);
    }

    private void removeEntry(ClassEntry classEntry) {
        ClassEntry previousDeobf = this.displayedObfToDeobf.get(classEntry);
        if (previousDeobf != null) {
            ClassSelectorPackageNode packageNode = this.getPackageNode(previousDeobf);
            this.removeNode(packageNode, previousDeobf);
            this.removeNodeIfEmpty(packageNode);
        }
    }

    public ClassSelectorPackageNode getOrCreatePackage(ClassEntry entry) {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ClassSelectorPackageNode newPackageNode = this.getPackageNode(entry);
        if (newPackageNode == null) {
            newPackageNode = new ClassSelectorPackageNode(entry.getPackageName());
            model.insertNodeInto(newPackageNode, (MutableTreeNode)model.getRoot(), this.getPlacementIndex(newPackageNode));
        }
        return newPackageNode;
    }

    public void insertNode(ClassEntry obfEntry) {
        ClassEntry deobfEntry = this.controller.project.getMapper().deobfuscate(obfEntry);
        ClassSelectorPackageNode packageNode = this.getOrCreatePackage(deobfEntry);
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        ClassSelectorClassNode classNode = new ClassSelectorClassNode(obfEntry, deobfEntry);
        model.insertNodeInto(classNode, packageNode, this.getPlacementIndex(packageNode, classNode));
        this.displayedObfToDeobf.put(obfEntry, deobfEntry);
    }

    public void reload() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        model.reload(this.rootNodes);
    }

    private int getPlacementIndex(ClassSelectorPackageNode newPackageNode, ClassSelectorClassNode classNode) {
        List<ClassSelectorClassNode> classNodes = this.classNodes(newPackageNode);
        classNodes.add(classNode);
        classNodes.sort((a, b) -> this.comparator.compare(a.getClassEntry(), b.getClassEntry()));
        for (int i = 0; i < classNodes.size(); ++i) {
            if (classNodes.get(i) != classNode) continue;
            return i;
        }
        return 0;
    }

    private int getPlacementIndex(ClassSelectorPackageNode newPackageNode) {
        List<ClassSelectorPackageNode> packageNodes = this.packageNodes();
        if (!packageNodes.contains(newPackageNode)) {
            packageNodes.add(newPackageNode);
            packageNodes.sort(Comparator.comparing(ClassSelectorPackageNode::toString));
        }
        for (int i = 0; i < packageNodes.size(); ++i) {
            if (packageNodes.get(i) != newPackageNode) continue;
            return i;
        }
        return 0;
    }

    public static interface RenameSelectionListener {
        public void onSelectionRename(Object var1, Object var2, DefaultMutableTreeNode var3);
    }

    public static interface ClassSelectionListener {
        public void onSelectClass(ClassEntry var1);
    }

    public static class StateEntry {
        public final State state;
        public final TreePath path;

        public StateEntry(State state, TreePath path) {
            this.state = state;
            this.path = path;
        }
    }

    public static enum State {
        EXPANDED,
        SELECTED;

    }
}

