/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import cuchaz.enigma.translation.Translatable;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMap;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryResolver;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.Map;
import java.util.function.Function;

public class TypeDescriptor
implements Translatable {
    protected final String desc;

    public TypeDescriptor(String desc) {
        Preconditions.checkNotNull((Object)desc, (Object)"Desc cannot be null");
        if (desc.charAt(0) == 'T' || desc.indexOf(60) >= 0 || desc.indexOf(62) >= 0) {
            throw new IllegalArgumentException("don't use with generic types or templates: " + desc);
        }
        this.desc = desc;
    }

    public static String parseFirst(String in) {
        if (in == null || in.length() <= 0) {
            throw new IllegalArgumentException("No desc to parse, input is empty!");
        }
        char c = in.charAt(0);
        if (c == 'V') {
            return "V";
        }
        Primitive primitive = Primitive.get(c);
        if (primitive != null) {
            return in.substring(0, 1);
        }
        if (c == 'L') {
            return TypeDescriptor.readClass(in);
        }
        if (c == 'T') {
            return TypeDescriptor.readClass(in);
        }
        int dim = TypeDescriptor.countArrayDimension(in);
        if (dim > 0) {
            String arrayType = TypeDescriptor.parseFirst(in.substring(dim));
            return in.substring(0, dim + arrayType.length());
        }
        throw new IllegalArgumentException("don't know how to parse: " + in);
    }

    private static int countArrayDimension(String in) {
        int i;
        for (i = 0; i < in.length() && in.charAt(i) == '['; ++i) {
        }
        return i;
    }

    private static String readClass(String in) {
        StringBuilder buf = new StringBuilder();
        int depth = 0;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            buf.append(c);
            if (c == '<') {
                ++depth;
                continue;
            }
            if (c == '>') {
                --depth;
                continue;
            }
            if (depth != 0 || c != ';') continue;
            return buf.toString();
        }
        return null;
    }

    public static TypeDescriptor of(String name) {
        return new TypeDescriptor("L" + name + ";");
    }

    public String toString() {
        return this.desc;
    }

    public boolean isVoid() {
        return this.desc.length() == 1 && this.desc.charAt(0) == 'V';
    }

    public boolean isPrimitive() {
        return this.desc.length() == 1 && Primitive.get(this.desc.charAt(0)) != null;
    }

    public Primitive getPrimitive() {
        if (!this.isPrimitive()) {
            throw new IllegalStateException("not a primitive");
        }
        return Primitive.get(this.desc.charAt(0));
    }

    public boolean isType() {
        return this.desc.charAt(0) == 'L' && this.desc.charAt(this.desc.length() - 1) == ';';
    }

    public ClassEntry getTypeEntry() {
        if (this.isType()) {
            String name = this.desc.substring(1, this.desc.length() - 1);
            int pos = name.indexOf(60);
            if (pos >= 0) {
                name = name.substring(0, pos);
            }
            return new ClassEntry(name);
        }
        if (this.isArray() && this.getArrayType().isType()) {
            return this.getArrayType().getTypeEntry();
        }
        throw new IllegalStateException("desc doesn't have a class");
    }

    public boolean isArray() {
        return this.desc.charAt(0) == '[';
    }

    public int getArrayDimension() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return TypeDescriptor.countArrayDimension(this.desc);
    }

    public TypeDescriptor getArrayType() {
        if (!this.isArray()) {
            throw new IllegalStateException("not an array");
        }
        return new TypeDescriptor(this.desc.substring(this.getArrayDimension()));
    }

    public boolean containsType() {
        return this.isType() || this.isArray() && this.getArrayType().containsType();
    }

    public boolean equals(Object other) {
        return other instanceof TypeDescriptor && this.equals((TypeDescriptor)other);
    }

    public boolean equals(TypeDescriptor other) {
        return this.desc.equals(other.desc);
    }

    public int hashCode() {
        return this.desc.hashCode();
    }

    public TypeDescriptor remap(Function<String, String> remapper) {
        String replacedName;
        String desc = this.desc;
        if ((this.isType() || this.isArray() && this.containsType()) && (replacedName = remapper.apply(this.getTypeEntry().getFullName())) != null) {
            desc = this.isType() ? "L" + replacedName + ";" : TypeDescriptor.getArrayPrefix(this.getArrayDimension()) + "L" + replacedName + ";";
        }
        return new TypeDescriptor(desc);
    }

    private static String getArrayPrefix(int dimension) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < dimension; ++i) {
            buf.append("[");
        }
        return buf.toString();
    }

    public int getSize() {
        switch (this.desc.charAt(0)) {
            case 'D': 
            case 'J': {
                if (this.desc.length() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    @Override
    public Translatable translate(Translator translator, EntryResolver resolver, EntryMap<EntryMapping> mappings) {
        return this.remap(name -> translator.translate(new ClassEntry((String)name)).getFullName());
    }

    public static enum Primitive {
        BYTE('B'),
        CHARACTER('C'),
        SHORT('S'),
        INTEGER('I'),
        LONG('J'),
        FLOAT('F'),
        DOUBLE('D'),
        BOOLEAN('Z');

        private static final Map<Character, Primitive> lookup;
        private char code;

        private Primitive(char code) {
            this.code = code;
        }

        public static Primitive get(char code) {
            return lookup.get(Character.valueOf(code));
        }

        public char getCode() {
            return this.code;
        }

        static {
            lookup = Maps.newTreeMap();
            for (Primitive val : Primitive.values()) {
                lookup.put(Character.valueOf(val.getCode()), val);
            }
        }
    }
}

