/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.source.procyon.typeloader;

import com.google.common.collect.Lists;
import com.strobel.assembler.metadata.Buffer;
import com.strobel.assembler.metadata.ITypeLoader;
import cuchaz.enigma.ClassProvider;
import cuchaz.enigma.source.procyon.typeloader.CachingClasspathTypeLoader;
import cuchaz.enigma.source.procyon.typeloader.CachingTypeLoader;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Function;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class CompiledSourceTypeLoader
extends CachingTypeLoader {
    private static final ITypeLoader CLASSPATH_TYPE_LOADER = new CachingClasspathTypeLoader();
    private final ClassProvider compiledSource;
    private final LinkedList<Function<ClassVisitor, ClassVisitor>> visitors = new LinkedList();

    public CompiledSourceTypeLoader(ClassProvider compiledSource) {
        this.compiledSource = compiledSource;
    }

    public void addVisitor(Function<ClassVisitor, ClassVisitor> visitor) {
        this.visitors.addFirst(visitor);
    }

    @Override
    protected byte[] doLoad(String className) {
        byte[] data = this.loadType(className);
        if (data == null) {
            return this.loadClasspath(className);
        }
        return data;
    }

    private byte[] loadClasspath(String name) {
        Buffer parentBuf = new Buffer();
        if (CLASSPATH_TYPE_LOADER.tryLoadType(name, parentBuf)) {
            return parentBuf.array();
        }
        return EMPTY_ARRAY;
    }

    private byte[] loadType(String className) {
        ClassWriter writer;
        ClassEntry entry = new ClassEntry(className);
        ClassNode node = this.findClassNode(entry);
        if (node == null) {
            return null;
        }
        this.removeRedundantClassCalls(node);
        ClassWriter visitor = writer = new ClassWriter(0);
        for (Function function : this.visitors) {
            visitor = (ClassVisitor)function.apply(visitor);
        }
        node.accept((ClassVisitor)visitor);
        return writer.toByteArray();
    }

    private void removeRedundantClassCalls(ClassNode node) {
        for (MethodNode methodNode : node.methods) {
            for (AbstractInsnNode insnNode = methodNode.instructions.getFirst(); insnNode != null; insnNode = insnNode.getNext()) {
                if (!(insnNode instanceof MethodInsnNode) || insnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)insnNode;
                if (!methodInsnNode.name.equals("getClass") || !methodInsnNode.owner.equals("java/lang/Object") || !methodInsnNode.desc.equals("()Ljava/lang/Class;")) continue;
                AbstractInsnNode previous = methodInsnNode.getPrevious();
                AbstractInsnNode next = methodInsnNode.getNext();
                if (previous.getOpcode() != 89 || next.getOpcode() != 87) continue;
                insnNode = previous.getPrevious();
                methodNode.instructions.remove(previous);
                methodNode.instructions.remove((AbstractInsnNode)methodInsnNode);
                methodNode.instructions.remove(next);
            }
        }
    }

    private ClassNode findClassNode(ClassEntry entry) {
        for (String className : this.getClassNamesToTry(entry)) {
            ClassNode node = this.compiledSource.getClassNode(className);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    private Collection<String> getClassNamesToTry(ClassEntry entry) {
        ArrayList classNamesToTry = Lists.newArrayList();
        classNamesToTry.add(entry.getFullName());
        ClassEntry outerClass = entry.getOuterClass();
        if (outerClass != null) {
            classNamesToTry.addAll(this.getClassNamesToTry(outerClass));
        }
        return classNamesToTry;
    }
}

