/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma;

import com.google.common.base.Functions;
import cuchaz.enigma.Enigma;
import cuchaz.enigma.ProgressListener;
import cuchaz.enigma.ProposingTranslator;
import cuchaz.enigma.analysis.ClassCache;
import cuchaz.enigma.analysis.EntryReference;
import cuchaz.enigma.analysis.index.JarIndex;
import cuchaz.enigma.api.service.NameProposalService;
import cuchaz.enigma.bytecode.translators.SourceFixVisitor;
import cuchaz.enigma.bytecode.translators.TranslationClassVisitor;
import cuchaz.enigma.source.Decompiler;
import cuchaz.enigma.source.DecompilerService;
import cuchaz.enigma.source.SourceSettings;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.mapping.EntryRemapper;
import cuchaz.enigma.translation.mapping.MappingsChecker;
import cuchaz.enigma.translation.mapping.tree.DeltaTrackingTree;
import cuchaz.enigma.translation.mapping.tree.EntryTree;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.Entry;
import cuchaz.enigma.translation.representation.entry.LocalVariableEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import cuchaz.enigma.utils.I18n;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public class EnigmaProject {
    private final Enigma enigma;
    private final ClassCache classCache;
    private final JarIndex jarIndex;
    private EntryRemapper mapper;

    public EnigmaProject(Enigma enigma, ClassCache classCache, JarIndex jarIndex) {
        this.enigma = enigma;
        this.classCache = classCache;
        this.jarIndex = jarIndex;
        this.mapper = EntryRemapper.empty(jarIndex);
    }

    public void setMappings(EntryTree<EntryMapping> mappings) {
        this.mapper = mappings != null ? EntryRemapper.mapped(this.jarIndex, mappings) : EntryRemapper.empty(this.jarIndex);
    }

    public Enigma getEnigma() {
        return this.enigma;
    }

    public ClassCache getClassCache() {
        return this.classCache;
    }

    public JarIndex getJarIndex() {
        return this.jarIndex;
    }

    public EntryRemapper getMapper() {
        return this.mapper;
    }

    public void dropMappings(ProgressListener progress) {
        DeltaTrackingTree<EntryMapping> mappings = this.mapper.getObfToDeobf();
        Collection<Entry<?>> dropped = this.dropMappings(mappings, progress);
        for (Entry<?> entry : dropped) {
            mappings.trackChange(entry);
        }
    }

    private Collection<Entry<?>> dropMappings(EntryTree<EntryMapping> mappings, ProgressListener progress) {
        MappingsChecker checker = new MappingsChecker(this.jarIndex, mappings);
        MappingsChecker.Dropped dropped = checker.dropBrokenMappings(progress);
        Map<Entry<?>, String> droppedMappings = dropped.getDroppedMappings();
        for (Map.Entry<Entry<?>, String> mapping : droppedMappings.entrySet()) {
            System.out.println("WARNING: Couldn't find " + mapping.getKey() + " (" + mapping.getValue() + ") in jar. Mapping was dropped.");
        }
        return droppedMappings.keySet();
    }

    public boolean isRenamable(Entry<?> obfEntry) {
        if (obfEntry instanceof MethodEntry) {
            MethodEntry obfMethodEntry = (MethodEntry)obfEntry;
            String name = obfMethodEntry.getName();
            String sig = obfMethodEntry.getDesc().toString();
            if (name.equals("clone") && sig.equals("()Ljava/lang/Object;")) {
                return false;
            }
            if (name.equals("equals") && sig.equals("(Ljava/lang/Object;)Z")) {
                return false;
            }
            if (name.equals("finalize") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("getClass") && sig.equals("()Ljava/lang/Class;")) {
                return false;
            }
            if (name.equals("hashCode") && sig.equals("()I")) {
                return false;
            }
            if (name.equals("notify") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("notifyAll") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("toString") && sig.equals("()Ljava/lang/String;")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("()V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(J)V")) {
                return false;
            }
            if (name.equals("wait") && sig.equals("(JI)V")) {
                return false;
            }
        } else if (obfEntry instanceof LocalVariableEntry && !((LocalVariableEntry)obfEntry).isArgument()) {
            return false;
        }
        return this.jarIndex.getEntryIndex().hasEntry(obfEntry);
    }

    public boolean isRenamable(EntryReference<Entry<?>, Entry<?>> obfReference) {
        return obfReference.isNamed() && this.isRenamable(obfReference.getNameableEntry());
    }

    public JarExport exportRemappedJar(ProgressListener progress) {
        Collection<ClassEntry> classEntries = this.jarIndex.getEntryIndex().getClasses();
        NameProposalService[] nameProposalServices = this.getEnigma().getServices().get(NameProposalService.TYPE).toArray(new NameProposalService[0]);
        Translator deobfuscator = nameProposalServices.length == 0 ? this.mapper.getDeobfuscator() : new ProposingTranslator(this.mapper, nameProposalServices);
        AtomicInteger count = new AtomicInteger();
        progress.init(classEntries.size(), I18n.translate("progress.classes.deobfuscating"));
        Map<String, ClassNode> compiled = classEntries.parallelStream().map(entry -> {
            ClassEntry translatedEntry = deobfuscator.translate(entry);
            progress.step(count.getAndIncrement(), translatedEntry.toString());
            ClassNode node = this.classCache.getClassNode(entry.getFullName());
            if (node != null) {
                ClassNode translatedNode = new ClassNode();
                node.accept((ClassVisitor)new TranslationClassVisitor(deobfuscator, 524288, new SourceFixVisitor(524288, (ClassVisitor)translatedNode, this.jarIndex)));
                return translatedNode;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toMap(n -> n.name, Functions.identity()));
        return new JarExport(this.jarIndex, compiled);
    }

    private static class ClassSource {
        private final String name;
        private final String source;

        ClassSource(String name, String source) {
            this.name = name;
            this.source = source;
        }

        void writeTo(Path path) throws IOException {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                writer.write(this.source);
            }
        }

        Path resolvePath(Path root) {
            return root.resolve(this.name.replace('.', '/') + ".java");
        }
    }

    public static final class SourceExport {
        private final Collection<ClassSource> decompiled;

        SourceExport(Collection<ClassSource> decompiled) {
            this.decompiled = decompiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.decompiled.size(), I18n.translate("progress.sources.writing"));
            int count = 0;
            for (ClassSource source : this.decompiled) {
                progress.step(count++, source.name);
                Path sourcePath = source.resolvePath(path);
                source.writeTo(sourcePath);
            }
        }
    }

    public static final class JarExport {
        private final JarIndex jarIndex;
        private final Map<String, ClassNode> compiled;

        JarExport(JarIndex jarIndex, Map<String, ClassNode> compiled) {
            this.jarIndex = jarIndex;
            this.compiled = compiled;
        }

        public void write(Path path, ProgressListener progress) throws IOException {
            progress.init(this.compiled.size(), I18n.translate("progress.jar.writing"));
            try (JarOutputStream out = new JarOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                AtomicInteger count = new AtomicInteger();
                for (ClassNode node : this.compiled.values()) {
                    progress.step(count.getAndIncrement(), node.name);
                    String entryName = node.name.replace('.', '/') + ".class";
                    ClassWriter writer = new ClassWriter(0);
                    node.accept((ClassVisitor)writer);
                    out.putNextEntry(new JarEntry(entryName));
                    out.write(writer.toByteArray());
                    out.closeEntry();
                }
            }
        }

        public SourceExport decompile(ProgressListener progress, DecompilerService decompilerService) {
            Collection classes = this.compiled.values().stream().filter(classNode -> classNode.name.indexOf(36) == -1).collect(Collectors.toList());
            progress.init(classes.size(), I18n.translate("progress.classes.decompiling"));
            Decompiler decompiler = decompilerService.create(this.compiled::get, new SourceSettings(false, false));
            AtomicInteger count = new AtomicInteger();
            Collection decompiled = classes.parallelStream().map(translatedNode -> {
                progress.step(count.getAndIncrement(), translatedNode.name);
                String source = this.decompileClass((ClassNode)translatedNode, decompiler);
                return new ClassSource(translatedNode.name, source);
            }).collect(Collectors.toList());
            return new SourceExport(decompiled);
        }

        private String decompileClass(ClassNode translatedNode, Decompiler decompiler) {
            return decompiler.getSource(translatedNode.name).asString();
        }
    }
}

