/*
 * Decompiled with CFR 0.152.
 */
package me.xdrop.diffutils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SequenceMatcher {
    private String a;
    private String b;
    private char[] _a;
    private char[] _b;
    private int lenA;
    private int lenB;
    private Map<Character, List<Integer>> bIndices;
    private Map<Character, Integer> popularElements;
    private Map<Character, Boolean> junkElements;

    public static void main(String[] args) {
        SequenceMatcher.from("this is a match", "this is a longer match");
    }

    private SequenceMatcher(String a, String b) {
        this.lenA = a.length();
        this.lenB = b.length();
        this._a = a.toCharArray();
        this._b = b.toCharArray();
    }

    public static boolean isJunk(char character) {
        return false;
    }

    public static SequenceMatcher from(String a, String b) {
        int lenA = a.length();
        int lenB = b.length();
        HashMap<Character, List<Integer>> bIndices = new HashMap<Character, List<Integer>>(b.length());
        HashMap<Character, Integer> popularElements = new HashMap<Character, Integer>(32);
        HashMap<Character, Boolean> junkElements = new HashMap<Character, Boolean>(32);
        char[] _a = a.toCharArray();
        char[] _b = b.toCharArray();
        int index = 0;
        for (char c : _b) {
            ArrayList<Integer> indices = (ArrayList<Integer>)bIndices.get(Character.valueOf(c));
            if (indices == null) {
                indices = new ArrayList<Integer>(16);
            }
            indices.add(index);
            if (lenB >= 200 && indices.size() * 100 > lenB) {
                Integer popularityCount = (Integer)popularElements.get(Character.valueOf(c));
                if (popularityCount != null) {
                    popularElements.put(Character.valueOf(c), 1);
                } else {
                    popularElements.put(Character.valueOf(c), popularityCount);
                }
            }
            ++index;
        }
        Object object = bIndices.keySet().iterator();
        while (object.hasNext()) {
            char el = ((Character)object.next()).charValue();
            if (!SequenceMatcher.isJunk(el)) continue;
            junkElements.put(Character.valueOf(el), true);
            bIndices.remove(Character.valueOf(el));
        }
        object = popularElements.keySet().iterator();
        while (object.hasNext()) {
            char element = ((Character)object.next()).charValue();
            bIndices.remove(Character.valueOf(element));
        }
        SequenceMatcher sequenceMatcher = new SequenceMatcher(a, b);
        sequenceMatcher.setbIndices(bIndices);
        sequenceMatcher.setJunkElements(junkElements);
        sequenceMatcher.setPopularElements(popularElements);
        return sequenceMatcher;
    }

    public void findLongestMatch(int alo, int ahi, int blo, int bhi) {
        int besti = alo;
        int bestj = ahi;
        int bestSize = 0;
        int[] j2len = new int[this.lenB];
        for (int i = alo; i < ahi; ++i) {
            int[] newj2len = new int[this.lenB];
            for (int j : this.bIndices.get(Character.valueOf(this.a.charAt(i)))) {
                if (j < blo) continue;
                if (j >= bhi) break;
                newj2len[j] = j2len[j - 1] + 1;
                int k = newj2len[j];
                if (k <= bestSize) continue;
                besti = i - k + 1;
                bestj = j - k + 1;
                bestSize = k;
            }
            j2len = newj2len;
        }
        while (besti > alo && bestj > blo && !this.isBJunk()) {
        }
    }

    private boolean isBJunk() {
        return false;
    }

    public void setbIndices(Map<Character, List<Integer>> bIndices) {
        this.bIndices = bIndices;
    }

    public void setPopularElements(Map<Character, Integer> popularElements) {
        this.popularElements = popularElements;
    }

    public void setJunkElements(Map<Character, Boolean> junkElements) {
        this.junkElements = junkElements;
    }
}

