/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane;

import de.sciss.syntaxpane.Lexer;
import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.SyntaxView;
import de.sciss.syntaxpane.actions.SyntaxAction;
import de.sciss.syntaxpane.components.SyntaxComponent;
import de.sciss.syntaxpane.util.Configuration;
import de.sciss.syntaxpane.util.JarServiceProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JEditorPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class DefaultSyntaxKit
extends DefaultEditorKit
implements ViewFactory {
    public static final String CONFIG_CARETCOLOR = "CaretColor";
    public static final String CONFIG_SELECTION = "SelectionColor";
    public static final String CONFIG_COMPONENTS = "Components";
    public static final String CONFIG_MENU = "PopupMenu";
    public static final String CONFIG_TOOLBAR = "Toolbar";
    public static final String CONFIG_TOOLBAR_ROLLOVER = "Toolbar.Buttons.Rollover";
    public static final String CONFIG_TOOLBAR_BORDER = "Toolbar.Buttons.BorderPainted";
    public static final String CONFIG_TOOLBAR_OPAQUE = "Toolbar.Buttons.Opaque";
    public static final String CONFIG_TOOLBAR_BORDER_SIZE = "Toolbar.Buttons.BorderSize";
    private static final Pattern ACTION_KEY_PATTERN;
    private static final Pattern DEFAULT_ACTION_PATTERN;
    private static Font DEFAULT_FONT;
    private static Set<String> CONTENT_TYPES;
    private static Boolean initialized;
    private static Map<String, String> abbreviations;
    private static String MENU_MASK_STRING;
    private Lexer lexer;
    private static final Logger LOG;
    private Map<JEditorPane, List<SyntaxComponent>> editorComponents = new WeakHashMap<JEditorPane, List<SyntaxComponent>>();
    private Map<JEditorPane, JPopupMenu> popupMenu = new WeakHashMap<JEditorPane, JPopupMenu>();
    private static Map<Class<? extends DefaultSyntaxKit>, Configuration> CONFIGS;
    private static final String PLATFORM_KEY;
    private static final String ACTION_MENU_TEXT = "MenuText";

    public DefaultSyntaxKit(Lexer lexer) {
        this.lexer = lexer;
    }

    public void addComponents(JEditorPane editorPane) {
        String[] components;
        for (String c : components = this.getConfig().getPropertyList(CONFIG_COMPONENTS)) {
            this.installComponent(editorPane, c);
        }
    }

    public void installComponent(JEditorPane pane, String className) {
        try {
            Class<?> compClass = Class.forName(className);
            SyntaxComponent comp = (SyntaxComponent)compClass.newInstance();
            comp.config(this.getConfig());
            comp.install(pane);
            if (this.editorComponents.get(pane) == null) {
                this.editorComponents.put(pane, new ArrayList());
            }
            this.editorComponents.get(pane).add(comp);
        }
        catch (InstantiationException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (ClassNotFoundException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
    }

    public void deinstallComponent(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            c.deinstall(pane);
            this.editorComponents.get(pane).remove(c);
            break;
        }
    }

    public boolean isComponentInstalled(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            return true;
        }
        return false;
    }

    public boolean toggleComponent(JEditorPane pane, String className) {
        for (SyntaxComponent c : this.editorComponents.get(pane)) {
            if (!c.getClass().getName().equals(className)) continue;
            c.deinstall(pane);
            this.editorComponents.get(pane).remove(c);
            return false;
        }
        this.installComponent(pane, className);
        return true;
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        super.read(in, doc, pos);
    }

    public void addPopupMenu(JEditorPane editorPane) {
        String[] menuItems = this.getConfig().getPropertyList(CONFIG_MENU);
        if (menuItems == null || menuItems.length == 0) {
            return;
        }
        this.popupMenu.put(editorPane, new JPopupMenu());
        Component stack = null;
        for (String menuString : menuItems) {
            if (menuString.equals("-")) {
                this.popupMenu.get(editorPane).addSeparator();
                continue;
            }
            if (menuString.startsWith(">")) {
                JMenu sub = new JMenu(menuString.substring(1));
                this.popupMenu.get(editorPane).add(sub);
                stack = sub;
                continue;
            }
            if (menuString.startsWith("<")) {
                Container parent;
                Container container = parent = stack == null ? null : stack.getParent();
                if (parent instanceof JMenu) {
                    stack = (JMenu)parent;
                    continue;
                }
                stack = null;
                continue;
            }
            Action action = editorPane.getActionMap().get(menuString);
            if (action == null) continue;
            JMenuItem menuItem = action.getValue("SwingSelectedKey") != null ? new JCheckBoxMenuItem(action) : new JMenuItem(action);
            if (action.getValue(ACTION_MENU_TEXT) != null) {
                menuItem.setText((String)action.getValue(ACTION_MENU_TEXT));
            }
            if (stack == null) {
                this.popupMenu.get(editorPane).add(menuItem);
                continue;
            }
            ((JMenu)stack).add(menuItem);
        }
        editorPane.setComponentPopupMenu(this.popupMenu.get(editorPane));
    }

    public void addToolBarActions(JEditorPane editorPane, JToolBar toolbar) {
        String[] toolBarItems = this.getConfig().getPropertyList(CONFIG_TOOLBAR);
        if (!(toolBarItems != null && toolBarItems.length != 0 || (toolBarItems = this.getConfig().getPropertyList(CONFIG_MENU)) != null && toolBarItems.length != 0)) {
            return;
        }
        boolean btnRolloverEnabled = this.getConfig().getBoolean(CONFIG_TOOLBAR_ROLLOVER, true);
        boolean btnBorderPainted = this.getConfig().getBoolean(CONFIG_TOOLBAR_BORDER, false);
        boolean btnOpaque = this.getConfig().getBoolean(CONFIG_TOOLBAR_OPAQUE, false);
        int btnBorderSize = this.getConfig().getInteger(CONFIG_TOOLBAR_BORDER_SIZE, 2);
        for (String menuString : toolBarItems) {
            if (menuString.equals("-") || menuString.startsWith("<") || menuString.startsWith(">")) {
                toolbar.addSeparator();
                continue;
            }
            Action action = editorPane.getActionMap().get(menuString);
            if (action == null || action.getValue("SmallIcon") == null) continue;
            JButton b = toolbar.add(action);
            b.setRolloverEnabled(btnRolloverEnabled);
            b.setBorderPainted(btnBorderPainted);
            b.setOpaque(btnOpaque);
            b.setFocusable(false);
            b.setBorder(BorderFactory.createEmptyBorder(btnBorderSize, btnBorderSize, btnBorderSize, btnBorderSize));
        }
    }

    @Override
    public ViewFactory getViewFactory() {
        return this;
    }

    @Override
    public View create(Element element) {
        return new SyntaxView(element, this.getConfig());
    }

    @Override
    public void install(JEditorPane editorPane) {
        super.install(editorPane);
        String fontName = this.getProperty("DefaultFont");
        Font font = DEFAULT_FONT;
        if (fontName != null) {
            font = Font.decode(fontName);
        }
        editorPane.setFont(font);
        Configuration conf = this.getConfig();
        Color caretColor = conf.getColor(CONFIG_CARETCOLOR, Color.BLACK);
        editorPane.setCaretColor(caretColor);
        Color selectionColor = this.getConfig().getColor(CONFIG_SELECTION, new Color(0x99CCFF));
        editorPane.setSelectionColor(selectionColor);
        this.addActions(editorPane);
        this.addComponents(editorPane);
        this.addPopupMenu(editorPane);
    }

    @Override
    public void deinstall(JEditorPane editorPane) {
        for (SyntaxComponent c : this.editorComponents.get(editorPane)) {
            c.deinstall(editorPane);
        }
        this.editorComponents.clear();
        editorPane.getInputMap().clear();
        ActionMap m3 = editorPane.getActionMap();
        for (Object key : editorPane.getActionMap().keys()) {
            Action a = m3.get(key);
            if (!(a instanceof SyntaxAction)) continue;
            ((SyntaxAction)a).deinstall(editorPane);
        }
        m3.clear();
    }

    public void addActions(JEditorPane editorPane) {
        InputMap imap = new InputMap();
        imap.setParent(editorPane.getInputMap());
        ActionMap amap = new ActionMap();
        amap.setParent(editorPane.getActionMap());
        for (Configuration.StringKeyMatcher m3 : this.getConfig().getKeys(ACTION_KEY_PATTERN)) {
            String[] values = Configuration.COMMA_SEPARATOR.split(m3.value);
            String actionClass = values[0];
            String actionName = m3.group1;
            SyntaxAction action = this.createAction(actionClass);
            action.install(editorPane, this.getConfig(), "Action." + actionName);
            amap.put(actionName, action);
            String platformKey = this.getProperty(m3.key + PLATFORM_KEY);
            for (int i = 1; i < values.length; ++i) {
                String ksString = values[i].replace("menu ", MENU_MASK_STRING);
                String keyStrokeString = platformKey == null ? ksString : platformKey;
                KeyStroke ks = KeyStroke.getKeyStroke(keyStrokeString);
                if (ks == null) {
                    throw new IllegalArgumentException("Invalid KeyStroke: " + keyStrokeString);
                }
                action.putValue("AcceleratorKey", ks);
                imap.put(ks, actionName);
            }
        }
        for (Configuration.StringKeyMatcher m3 : this.getConfig().getKeys(DEFAULT_ACTION_PATTERN)) {
            String name = m3.matcher.group(2);
            Action action = editorPane.getActionMap().get(name);
            if (action == null) continue;
            this.configActionProperties(action, name, m3.group1);
        }
        editorPane.setActionMap(amap);
        editorPane.setInputMap(0, imap);
    }

    private void configActionProperties(Action action, String actionName, String configKey) {
        String iconLoc = this.getConfig().getString(configKey + ".SmallIcon", actionName + ".png");
        URL loc = this.getClass().getClassLoader().getResource("de/sciss/syntaxpane/images/small-icons/" + iconLoc);
        if (loc != null) {
            ImageIcon i = new ImageIcon(loc);
            action.putValue("SmallIcon", i);
        }
        String name = this.getProperty(configKey + ".MenuText");
        if (action.getValue("Name") == null) {
            action.putValue("Name", name);
        } else {
            action.putValue(ACTION_MENU_TEXT, name);
        }
        String shortDesc = this.getProperty(configKey + ".ToolTip");
        if (shortDesc != null) {
            action.putValue("ShortDescription", shortDesc);
        } else {
            action.putValue("ShortDescription", name);
        }
    }

    private SyntaxAction createAction(String actionClassName) {
        SyntaxAction action;
        try {
            Class<?> clazz = Class.forName(actionClassName);
            action = (SyntaxAction)clazz.newInstance();
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName + ". Ensure it has default constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        catch (ClassCastException ex) {
            throw new IllegalArgumentException("Cannot create action class: " + actionClassName, ex);
        }
        return action;
    }

    @Override
    public Document createDefaultDocument() {
        return new SyntaxDocument(this.lexer);
    }

    public static synchronized void initKit() {
        String defaultFont = DefaultSyntaxKit.getConfig(DefaultSyntaxKit.class).getString("DefaultFont");
        if (defaultFont != null) {
            DEFAULT_FONT = Font.decode(defaultFont);
        } else {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Object[] fonts = ge.getAvailableFontFamilyNames();
            Arrays.sort(fonts);
            if (Arrays.binarySearch(fonts, "Courier New") >= 0) {
                DEFAULT_FONT = new Font("Courier New", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Courier") >= 0) {
                DEFAULT_FONT = new Font("Courier", 0, 12);
            } else if (Arrays.binarySearch(fonts, "Monospaced") >= 0) {
                DEFAULT_FONT = new Font("Monospaced", 0, 13);
            }
        }
        Properties kitsForTypes = JarServiceProvider.readProperties("de/sciss/syntaxpane/kitsfortypes");
        for (Map.Entry<Object, Object> e : kitsForTypes.entrySet()) {
            String type = e.getKey().toString();
            String className = e.getValue().toString();
            DefaultSyntaxKit.registerContentType(type, className);
        }
        initialized = true;
    }

    public static void registerContentType(String type, String className) {
        try {
            Class<?> c = Class.forName(className);
            Object kit = c.newInstance();
            if (!(kit instanceof EditorKit)) {
                throw new IllegalArgumentException("Cannot register class: " + className + ". It does not extend EditorKit");
            }
            JEditorPane.registerEditorKitForContentType(type, className);
            CONTENT_TYPES.add(type);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className + ". Ensure it has Default Constructor.", ex);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
        catch (RuntimeException ex) {
            throw new IllegalArgumentException("Cannot register class: " + className, ex);
        }
    }

    public static String[] getContentTypes() {
        Object[] types = CONTENT_TYPES.toArray(new String[0]);
        Arrays.sort(types);
        return types;
    }

    public void setConfig(Properties config) {
        this.getConfig().putAll((Map)config);
    }

    public void setProperty(String key, String value) {
        this.getConfig().put(key, value);
    }

    public String getProperty(String key) {
        return this.getConfig().getString(key);
    }

    public Configuration getConfig() {
        return DefaultSyntaxKit.getConfig(this.getClass());
    }

    public static synchronized Configuration getConfig(Class<? extends DefaultSyntaxKit> kit) {
        if (CONFIGS == null) {
            CONFIGS = new WeakHashMap<Class<? extends DefaultSyntaxKit>, Configuration>();
            Configuration defaultConfig = new Configuration(DefaultSyntaxKit.class);
            DefaultSyntaxKit.loadConfig(defaultConfig, DefaultSyntaxKit.class);
            CONFIGS.put(DefaultSyntaxKit.class, defaultConfig);
        }
        if (CONFIGS.containsKey(kit)) {
            return CONFIGS.get(kit);
        }
        Class<? extends DefaultSyntaxKit> superKit = kit.getSuperclass();
        Configuration defaults = DefaultSyntaxKit.getConfig(superKit);
        Configuration mine = new Configuration(kit, defaults);
        DefaultSyntaxKit.loadConfig(mine, kit);
        CONFIGS.put(kit, mine);
        return mine;
    }

    public Map<String, String> getAbbreviations() {
        if (abbreviations == null) {
            String cl = this.getClass().getName().replace('.', '/').toLowerCase();
            abbreviations = JarServiceProvider.readStringsMap(cl + "/abbreviations.properties");
        }
        return abbreviations;
    }

    public static void addAbbreviation(String abbr, String template) {
        if (abbreviations == null) {
            abbreviations = new HashMap<String, String>();
        }
        abbreviations.put(abbr, template);
    }

    public static String getAbbreviation(String abbr) {
        return abbreviations == null ? null : abbreviations.get(abbr);
    }

    private static void loadConfig(Configuration conf, Class<? extends EditorKit> kit) {
        String url = kit.getName().replace(".", "/") + "/config";
        Properties p = JarServiceProvider.readProperties(url, Locale.getDefault());
        if (p.size() == 0) {
            LOG.log(Level.INFO, "unable to load configuration for: {0} from: {1}.properties", new Object[]{kit, url});
        } else {
            conf.putAll((Map)p);
        }
    }

    @Override
    public String getContentType() {
        return "text/" + this.getClass().getSimpleName().replace("SyntaxKit", "").toLowerCase();
    }

    static {
        int menuMask;
        ACTION_KEY_PATTERN = Pattern.compile("Action\\.((\\w|-)+)");
        DEFAULT_ACTION_PATTERN = Pattern.compile("(DefaultAction.((\\w|-)+)).*");
        CONTENT_TYPES = new HashSet<String>();
        initialized = false;
        MENU_MASK_STRING = "control ";
        LOG = Logger.getLogger(DefaultSyntaxKit.class.getName());
        if (!initialized.booleanValue()) {
            DefaultSyntaxKit.initKit();
        }
        if (((menuMask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) & 0x208) != 0) {
            MENU_MASK_STRING = "alt ";
        } else if ((menuMask & 0x104) != 0) {
            MENU_MASK_STRING = "meta ";
        }
        String osName = System.getProperty("os.name");
        PLATFORM_KEY = osName.contains("Linux") ? ".LinuxKey" : (osName.contains("Mac") ? ".MacKey" : ".WindowsKey");
    }
}

