/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.translation.representation.entry;

import com.google.common.base.Preconditions;
import cuchaz.enigma.translation.Translator;
import cuchaz.enigma.translation.mapping.EntryMapping;
import cuchaz.enigma.translation.representation.AccessFlags;
import cuchaz.enigma.translation.representation.MethodDescriptor;
import cuchaz.enigma.translation.representation.Signature;
import cuchaz.enigma.translation.representation.entry.ClassEntry;
import cuchaz.enigma.translation.representation.entry.DefEntry;
import cuchaz.enigma.translation.representation.entry.MethodEntry;
import javax.annotation.Nullable;

public class MethodDefEntry
extends MethodEntry
implements DefEntry<ClassEntry> {
    private final AccessFlags access;
    private final Signature signature;

    public MethodDefEntry(ClassEntry owner, String name, MethodDescriptor descriptor, Signature signature, AccessFlags access) {
        this(owner, name, descriptor, signature, access, null);
    }

    public MethodDefEntry(ClassEntry owner, String name, MethodDescriptor descriptor, Signature signature, AccessFlags access, String docs) {
        super(owner, name, descriptor, docs);
        Preconditions.checkNotNull(access, "Method access cannot be null");
        Preconditions.checkNotNull(signature, "Method signature cannot be null");
        this.access = access;
        this.signature = signature;
    }

    public static MethodDefEntry parse(ClassEntry owner, int access, String name, String desc, String signature) {
        return new MethodDefEntry(owner, name, new MethodDescriptor(desc), Signature.createSignature(signature), new AccessFlags(access), null);
    }

    @Override
    public AccessFlags getAccess() {
        return this.access;
    }

    public Signature getSignature() {
        return this.signature;
    }

    @Override
    public MethodDefEntry translate(Translator translator, @Nullable EntryMapping mapping) {
        MethodDescriptor translatedDesc = translator.translate(this.descriptor);
        Signature translatedSignature = translator.translate(this.signature);
        String translatedName = mapping != null ? mapping.getTargetName() : this.name;
        AccessFlags translatedAccess = mapping != null ? mapping.getAccessModifier().transform(this.access) : this.access;
        String docs = mapping != null ? mapping.getJavadoc() : null;
        return new MethodDefEntry((ClassEntry)this.parent, translatedName, translatedDesc, translatedSignature, translatedAccess, docs);
    }

    @Override
    public MethodDefEntry withName(String name) {
        return new MethodDefEntry((ClassEntry)this.parent, name, this.descriptor, this.signature, this.access, this.javadocs);
    }

    @Override
    public MethodDefEntry withParent(ClassEntry parent) {
        return new MethodDefEntry(new ClassEntry(parent.getFullName()), this.name, this.descriptor, this.signature, this.access, this.javadocs);
    }
}

