/*
 * Decompiled with CFR 0.152.
 */
package cuchaz.enigma.gui.elements;

import cuchaz.enigma.config.Config;
import cuchaz.enigma.config.Themes;
import cuchaz.enigma.gui.Gui;
import cuchaz.enigma.gui.dialog.AboutDialog;
import cuchaz.enigma.gui.dialog.SearchDialog;
import cuchaz.enigma.gui.stats.StatsMember;
import cuchaz.enigma.translation.mapping.serde.MappingFormat;
import cuchaz.enigma.utils.I18n;
import java.awt.Container;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    public final JMenuItem closeJarMenu;
    public final List<JMenuItem> openMappingsMenus;
    public final JMenuItem saveMappingsMenu;
    public final List<JMenuItem> saveMappingsMenus;
    public final JMenuItem closeMappingsMenu;
    public final JMenuItem dropMappingsMenu;
    public final JMenuItem exportSourceMenu;
    public final JMenuItem exportJarMenu;
    private final Gui gui;

    public MenuBar(Gui gui) {
        this.gui = gui;
        JMenu menu = new JMenu(I18n.translate("menu.file"));
        this.add(menu);
        JMenuItem item = new JMenuItem(I18n.translate("menu.file.jar.open"));
        menu.add(item);
        item.addActionListener(event -> {
            Path path;
            this.gui.jarFileChooser.setVisible(true);
            String file = this.gui.jarFileChooser.getFile();
            if (file != null && Files.exists(path = Paths.get(this.gui.jarFileChooser.getDirectory(), new String[0]).resolve(file), new LinkOption[0])) {
                gui.getController().openJar(path);
            }
        });
        item = new JMenuItem(I18n.translate("menu.file.jar.close"));
        menu.add(item);
        item.addActionListener(event -> this.gui.getController().closeJar());
        this.closeJarMenu = item;
        menu.addSeparator();
        Config.Decompiler[] openMenu = new JMenu(I18n.translate("menu.file.mappings.open"));
        menu.add((JMenuItem)openMenu);
        this.openMappingsMenus = new ArrayList<JMenuItem>();
        for (MappingFormat format : MappingFormat.values()) {
            if (format.getReader() == null) continue;
            JMenuItem item2 = new JMenuItem(I18n.translate("mapping_format." + format.name().toLowerCase(Locale.ROOT)));
            openMenu.add(item2);
            item2.addActionListener(event -> {
                if (this.gui.enigmaMappingsFileChooser.showOpenDialog(this.gui.getFrame()) == 0) {
                    File selectedFile = this.gui.enigmaMappingsFileChooser.getSelectedFile();
                    this.gui.getController().openMappings(format, selectedFile.toPath());
                }
            });
            this.openMappingsMenus.add(item2);
        }
        JMenuItem item3 = new JMenuItem(I18n.translate("menu.file.mappings.save"));
        menu.add(item3);
        item3.addActionListener(event -> this.gui.getController().saveMappings(this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath()));
        item3.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.saveMappingsMenu = item3;
        JMenu saveMenu = new JMenu(I18n.translate("menu.file.mappings.save_as"));
        menu.add(saveMenu);
        this.saveMappingsMenus = new ArrayList<JMenuItem>();
        for (MappingFormat format : MappingFormat.values()) {
            if (format.getWriter() == null) continue;
            JMenuItem item4 = new JMenuItem(I18n.translate("mapping_format." + format.name().toLowerCase(Locale.ROOT)));
            saveMenu.add(item4);
            item4.addActionListener(event -> {
                if (this.gui.enigmaMappingsFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                    this.gui.getController().saveMappings(this.gui.enigmaMappingsFileChooser.getSelectedFile().toPath(), format);
                    this.saveMappingsMenu.setEnabled(true);
                }
            });
            this.saveMappingsMenus.add(item4);
        }
        JMenuItem item5 = new JMenuItem(I18n.translate("menu.file.mappings.close"));
        menu.add(item5);
        item5.addActionListener(event -> {
            if (this.gui.getController().isDirty()) {
                this.gui.showDiscardDiag(response -> {
                    if (response == 0) {
                        gui.saveMapping();
                        this.gui.getController().closeMappings();
                    } else if (response == 1) {
                        this.gui.getController().closeMappings();
                    }
                    return null;
                }, I18n.translate("prompt.close.save"), I18n.translate("prompt.close.discard"), I18n.translate("prompt.close.cancel"));
            } else {
                this.gui.getController().closeMappings();
            }
        });
        this.closeMappingsMenu = item5;
        item5 = new JMenuItem(I18n.translate("menu.file.mappings.drop"));
        menu.add(item5);
        item5.addActionListener(event -> this.gui.getController().dropMappings());
        this.dropMappingsMenu = item5;
        menu.addSeparator();
        item5 = new JMenuItem(I18n.translate("menu.file.export.source"));
        menu.add(item5);
        item5.addActionListener(event -> {
            if (this.gui.exportSourceFileChooser.showSaveDialog(this.gui.getFrame()) == 0) {
                this.gui.getController().exportSource(this.gui.exportSourceFileChooser.getSelectedFile().toPath());
            }
        });
        this.exportSourceMenu = item5;
        item5 = new JMenuItem(I18n.translate("menu.file.export.jar"));
        menu.add(item5);
        item5.addActionListener(event -> {
            this.gui.exportJarFileChooser.setVisible(true);
            if (this.gui.exportJarFileChooser.getFile() != null) {
                Path path = Paths.get(this.gui.exportJarFileChooser.getDirectory(), this.gui.exportJarFileChooser.getFile());
                this.gui.getController().exportJar(path);
            }
        });
        this.exportJarMenu = item5;
        menu.addSeparator();
        JMenuItem stats = new JMenuItem(I18n.translate("menu.file.stats"));
        stats.addActionListener(event -> {
            JFrame frame = new JFrame(I18n.translate("menu.file.stats.title"));
            Container pane = frame.getContentPane();
            pane.setLayout(new FlowLayout());
            Map<StatsMember, JCheckBox> checkboxes = Arrays.stream(StatsMember.values()).collect(Collectors.toMap(m3 -> m3, m3 -> {
                JCheckBox checkbox = new JCheckBox(I18n.translate("type." + m3.name().toLowerCase(Locale.ROOT)));
                pane.add(checkbox);
                return checkbox;
            }));
            JButton button = new JButton(I18n.translate("menu.file.stats.generate"));
            button.addActionListener(e -> {
                Set<StatsMember> includedMembers = checkboxes.entrySet().stream().filter(entry -> ((JCheckBox)entry.getValue()).isSelected()).map(Map.Entry::getKey).collect(Collectors.toSet());
                frame.setVisible(false);
                frame.dispose();
                gui.getController().openStats(includedMembers);
            });
            pane.add(button);
            frame.pack();
            frame.setLocationRelativeTo(this.gui.getFrame());
            frame.setVisible(true);
        });
        menu.add(stats);
        menu.addSeparator();
        item5 = new JMenuItem(I18n.translate("menu.file.exit"));
        menu.add(item5);
        item5.addActionListener(event -> this.gui.close());
        menu = new JMenu(I18n.translate("menu.decompiler"));
        this.add(menu);
        for (Config.Decompiler decompiler : Config.Decompiler.values()) {
            JMenuItem label = new JMenuItem(decompiler.name);
            menu.add(label);
            label.addActionListener(event -> {
                gui.getController().setDecompiler(decompiler.service);
                try {
                    Config.getInstance().decompiler = decompiler;
                    Config.getInstance().saveConfig();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        menu = new JMenu(I18n.translate("menu.view"));
        this.add(menu);
        JMenu themes = new JMenu(I18n.translate("menu.view.themes"));
        menu.add(themes);
        for (Config.LookAndFeel lookAndFeel : Config.LookAndFeel.values()) {
            JMenuItem theme = new JMenuItem(I18n.translate("menu.view.themes." + lookAndFeel.name().toLowerCase(Locale.ROOT)));
            themes.add(theme);
            theme.addActionListener(event -> Themes.setLookAndFeel(gui, lookAndFeel));
        }
        JMenu languages = new JMenu(I18n.translate("menu.view.languages"));
        menu.add(languages);
        for (String lang : I18n.getAvailableLanguages()) {
            JMenuItem language = new JMenuItem(I18n.getLanguageName(lang));
            languages.add(language);
            language.addActionListener(event -> I18n.setLanguage(lang));
            language.addActionListener(event -> {
                JFrame frame = new JFrame(I18n.translate("menu.view.languages.title"));
                Container pane = frame.getContentPane();
                pane.setLayout(new FlowLayout());
                JLabel text = new JLabel(I18n.translate("menu.view.languages.summary"));
                text.setHorizontalAlignment(0);
                pane.add(text);
                JButton okButton = new JButton(I18n.translate("menu.view.languages.ok"));
                pane.add(okButton);
                okButton.addActionListener(arg0 -> frame.dispose());
                frame.pack();
                frame.setLocationRelativeTo(this.gui.getFrame());
                frame.setVisible(true);
            });
        }
        JMenuItem search = new JMenuItem(I18n.translate("menu.view.search"));
        search.setAccelerator(KeyStroke.getKeyStroke(32, 1));
        menu.add(search);
        search.addActionListener(event -> {
            if (this.gui.getController().project != null) {
                new SearchDialog(this.gui).show();
            }
        });
        menu = new JMenu(I18n.translate("menu.help"));
        this.add(menu);
        item = new JMenuItem(I18n.translate("menu.help.about"));
        menu.add(item);
        item.addActionListener(event -> AboutDialog.show(this.gui.getFrame()));
        item = new JMenuItem(I18n.translate("menu.help.github"));
        menu.add(item);
        item.addActionListener(event -> {
            try {
                Desktop.getDesktop().browse(new URL("https://github.com/FabricMC/Enigma").toURI());
            }
            catch (IOException | URISyntaxException exception) {
                // empty catch block
            }
        });
    }
}

