/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast.transforms;

import com.strobel.core.CollectionUtilities;
import com.strobel.core.Predicate;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.DecompilerContext;
import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.BlockStatement;
import com.strobel.decompiler.languages.java.ast.BreakStatement;
import com.strobel.decompiler.languages.java.ast.ConstructorDeclaration;
import com.strobel.decompiler.languages.java.ast.ContextTrackingVisitor;
import com.strobel.decompiler.languages.java.ast.ContinueStatement;
import com.strobel.decompiler.languages.java.ast.ForStatement;
import com.strobel.decompiler.languages.java.ast.GotoStatement;
import com.strobel.decompiler.languages.java.ast.LabelStatement;
import com.strobel.decompiler.languages.java.ast.LabeledStatement;
import com.strobel.decompiler.languages.java.ast.MethodDeclaration;
import com.strobel.decompiler.languages.java.ast.PrimitiveExpression;
import com.strobel.decompiler.languages.java.ast.Statement;
import com.strobel.decompiler.languages.java.ast.SwitchSection;
import com.strobel.decompiler.languages.java.ast.SwitchStatement;
import com.strobel.decompiler.languages.java.ast.WhileStatement;
import com.strobel.functions.Function;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public final class BreakTargetRelocation
extends ContextTrackingVisitor<Void> {
    public BreakTargetRelocation(DecompilerContext context) {
        super(context);
    }

    @Override
    public Void visitMethodDeclaration(MethodDeclaration node, Void p) {
        super.visitMethodDeclaration(node, p);
        this.runForMethod(node);
        return null;
    }

    @Override
    public Void visitConstructorDeclaration(ConstructorDeclaration node, Void p) {
        super.visitConstructorDeclaration(node, p);
        this.runForMethod(node);
        return null;
    }

    private void runForMethod(AstNode node) {
        LinkedHashMap<String, LabelInfo> labels = new LinkedHashMap<String, LabelInfo>();
        for (AstNode n : node.getDescendantsAndSelf()) {
            LabelInfo labelInfo;
            if (n instanceof LabelStatement) {
                LabelStatement label = (LabelStatement)n;
                labelInfo = (LabelInfo)labels.get(label.getLabel());
                if (labelInfo == null) {
                    labels.put(label.getLabel(), new LabelInfo(label));
                    continue;
                }
                labelInfo.label = label;
                labelInfo.labelTarget = label.getNextSibling();
                labelInfo.labelIsLast = true;
                continue;
            }
            if (!(n instanceof GotoStatement)) continue;
            GotoStatement gotoStatement = (GotoStatement)n;
            labelInfo = (LabelInfo)labels.get(gotoStatement.getLabel());
            if (labelInfo == null) {
                labelInfo = new LabelInfo(gotoStatement.getLabel());
                labels.put(gotoStatement.getLabel(), labelInfo);
            } else {
                labelInfo.labelIsLast = false;
            }
            labelInfo.gotoStatements.add(gotoStatement);
        }
        for (LabelInfo labelInfo : labels.values()) {
            this.run(labelInfo);
        }
    }

    private void run(LabelInfo labelInfo) {
        AstNode existingLoop;
        Statement insertedStatement;
        LabeledStatement labeledStatement;
        Statement loop;
        Object s2;
        assert (labelInfo != null);
        LabelStatement label = labelInfo.label;
        if (label == null || labelInfo.gotoStatements.isEmpty()) {
            return;
        }
        ArrayList<Stack<AstNode>> paths = new ArrayList<Stack<AstNode>>();
        for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
            paths.add(this.buildPath(gotoStatement));
        }
        paths.add(this.buildPath(label));
        Statement commonAncestor = this.findLowestCommonAncestor(paths);
        if (commonAncestor instanceof SwitchStatement && labelInfo.gotoStatements.size() == 1 && label.getParent() instanceof BlockStatement && label.getParent().getParent() instanceof SwitchSection && label.getParent().getParent().getParent() == commonAncestor && ((AstNode)(s2 = labelInfo.gotoStatements.get(0))).getParent() instanceof BlockStatement && ((AstNode)s2).getParent().getParent() instanceof SwitchSection && ((AstNode)s2).getParent().getParent().getParent() == commonAncestor) {
            SwitchStatement parentSwitch = (SwitchStatement)commonAncestor;
            SwitchSection targetSection = (SwitchSection)label.getParent().getParent();
            BlockStatement fallThroughBlock = (BlockStatement)((AstNode)s2).getParent();
            SwitchSection fallThroughSection = (SwitchSection)fallThroughBlock.getParent();
            if (fallThroughSection.getNextSibling() != targetSection) {
                fallThroughSection.remove();
                parentSwitch.getSwitchSections().insertBefore(targetSection, fallThroughSection);
            }
            BlockStatement blockStatement = (BlockStatement)label.getParent();
            ((AstNode)s2).remove();
            label.remove();
            if (fallThroughBlock.getStatements().isEmpty()) {
                fallThroughBlock.remove();
            }
            if (blockStatement.getStatements().isEmpty()) {
                blockStatement.remove();
            }
            return;
        }
        paths.clear();
        for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
            paths.add(this.buildPath(gotoStatement));
        }
        paths.add(this.buildPath(label));
        BlockStatement parent = this.findLowestCommonAncestorBlock(paths);
        if (parent == null) {
            return;
        }
        if (this.convertToContinue(parent, labelInfo, paths)) {
            return;
        }
        LinkedHashSet<AstNode> remainingNodes = new LinkedHashSet<AstNode>();
        LinkedList<AstNode> orderedNodes = new LinkedList<AstNode>();
        AstNode startNode = (AstNode)((Stack)paths.get(0)).peek();
        assert (startNode != null);
        for (Stack stack : paths) {
            if (stack.isEmpty()) {
                return;
            }
            remainingNodes.add((AstNode)stack.peek());
        }
        AstNode current = startNode;
        block3: while (BreakTargetRelocation.lookAhead(current, remainingNodes)) {
            while (current != null && !remainingNodes.isEmpty()) {
                if (current instanceof Statement) {
                    orderedNodes.addLast(current);
                }
                if (remainingNodes.remove(current)) continue block3;
                current = current.getNextSibling();
            }
        }
        if (!remainingNodes.isEmpty()) {
            current = startNode.getPreviousSibling();
            block5: while (BreakTargetRelocation.lookBehind(current, remainingNodes)) {
                while (current != null && !remainingNodes.isEmpty()) {
                    if (current instanceof Statement) {
                        orderedNodes.addFirst(current);
                    }
                    if (remainingNodes.remove(current)) continue block5;
                    current = current.getPreviousSibling();
                }
            }
        }
        if (!remainingNodes.isEmpty()) {
            return;
        }
        AstNode astNode = ((AstNode)orderedNodes.getLast()).getNextSibling();
        AstNode insertAfter = ((AstNode)orderedNodes.getFirst()).getPreviousSibling();
        BlockStatement newBlock = new BlockStatement();
        AstNodeCollection<Statement> blockStatements = newBlock.getStatements();
        AssessForLoopResult loopData = this.assessForLoop(commonAncestor, paths, label, labelInfo.gotoStatements);
        boolean rewriteAsLoop = !loopData.continueStatements.isEmpty();
        for (AstNode node : orderedNodes) {
            node.remove();
            blockStatements.add((Statement)node);
        }
        label.remove();
        if (rewriteAsLoop) {
            loop = new WhileStatement(new PrimitiveExpression(-34, true));
            ((WhileStatement)loop).setEmbeddedStatement(newBlock);
            if (!AstNode.isUnconditionalBranch(CollectionUtilities.lastOrDefault(newBlock.getStatements()))) {
                newBlock.getStatements().add(new BreakStatement(-34));
            }
            if (loopData.needsLabel) {
                labeledStatement = new LabeledStatement(label.getLabel(), loop);
                insertedStatement = labeledStatement;
                labelInfo.newLabeledStatement = labeledStatement;
            } else {
                insertedStatement = loop;
            }
        } else if (newBlock.getStatements().hasSingleElement() && AstNode.isLoop(newBlock.getStatements().firstOrNullObject())) {
            loop = newBlock.getStatements().firstOrNullObject();
            loop.remove();
            labeledStatement = new LabeledStatement(label.getLabel(), loop);
            insertedStatement = labeledStatement;
            labelInfo.newLabeledStatement = labeledStatement;
        } else {
            LabeledStatement labeledStatement2 = new LabeledStatement(label.getLabel(), newBlock);
            insertedStatement = labeledStatement2;
            labelInfo.newLabeledStatement = labeledStatement2;
        }
        if (parent.getParent() instanceof LabelStatement) {
            Object insertionPoint = parent;
            while (insertionPoint != null && ((AstNode)insertionPoint).getParent() instanceof LabelStatement) {
                insertionPoint = CollectionUtilities.firstOrDefault(((AstNode)insertionPoint).getAncestors(BlockStatement.class));
            }
            if (insertionPoint == null) {
                return;
            }
            ((AstNode)insertionPoint).addChild(insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else if (astNode != null) {
            parent.insertChildBefore(astNode, insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else if (insertAfter != null) {
            parent.insertChildAfter(insertAfter, insertedStatement, BlockStatement.STATEMENT_ROLE);
        } else {
            parent.getStatements().add(insertedStatement);
        }
        for (GotoStatement gotoStatement : labelInfo.gotoStatements) {
            if (loopData.continueStatements.contains(gotoStatement)) {
                ContinueStatement continueStatement = new ContinueStatement(-34);
                if (loopData.needsLabel) {
                    continueStatement.setLabel(gotoStatement.getLabel());
                }
                gotoStatement.replaceWith(continueStatement);
                continue;
            }
            BreakStatement breakStatement = new BreakStatement(-34);
            breakStatement.setLabel(gotoStatement.getLabel());
            gotoStatement.replaceWith(breakStatement);
        }
        if (rewriteAsLoop && !loopData.preexistingContinueStatements.isEmpty() && (existingLoop = CollectionUtilities.firstOrDefault(insertedStatement.getAncestors(), new Predicate<AstNode>(){

            @Override
            public boolean test(AstNode node) {
                return AstNode.isLoop(node);
            }
        })) != null) {
            final String loopLabel = label.getLabel() + "_Outer";
            existingLoop.replaceWith(new Function<AstNode, AstNode>(){

                @Override
                public AstNode apply(AstNode input) {
                    return new LabeledStatement(loopLabel, (Statement)existingLoop);
                }
            });
            for (ContinueStatement statement : loopData.preexistingContinueStatements) {
                statement.setLabel(loopLabel);
            }
        }
    }

    private boolean convertToContinue(BlockStatement parent, final LabelInfo labelInfo, List<Stack<AstNode>> paths) {
        boolean isContinue;
        if (!AstNode.isLoop(parent.getParent())) {
            return false;
        }
        AstNode loop = parent.getParent();
        AstNode nextAfterLoop = loop.getNextNode();
        AstNode n = labelInfo.label;
        while (n.getNextSibling() == null) {
            n = n.getParent();
        }
        boolean bl = isContinue = (n = n.getNextSibling()) == nextAfterLoop || loop instanceof ForStatement && n.getRole() == ForStatement.ITERATOR_ROLE && n.getParent() == loop;
        if (!isContinue) {
            return false;
        }
        boolean loopNeedsLabel = false;
        for (AstNode astNode : loop.getDescendantsAndSelf()) {
            if (astNode instanceof ContinueStatement && StringUtilities.equals(((ContinueStatement)astNode).getLabel(), labelInfo.name)) {
                loopNeedsLabel = true;
                continue;
            }
            if (!(astNode instanceof BreakStatement) || !StringUtilities.equals(((BreakStatement)astNode).getLabel(), labelInfo.name)) continue;
            loopNeedsLabel = true;
        }
        for (Stack stack : paths) {
            AstNode start = (AstNode)stack.firstElement();
            boolean continueNeedsLabel = false;
            if (!(start instanceof GotoStatement)) continue;
            for (AstNode node = start; node != null && node != loop; node = node.getParent()) {
                if (!AstNode.isLoop(node)) continue;
                continueNeedsLabel = true;
                loopNeedsLabel = true;
                break;
            }
            int offset = ((GotoStatement)start).getOffset();
            if (continueNeedsLabel) {
                start.replaceWith(new ContinueStatement(offset, labelInfo.name));
                continue;
            }
            start.replaceWith(new ContinueStatement(offset));
        }
        labelInfo.label.remove();
        if (loopNeedsLabel) {
            loop.replaceWith(new Function<AstNode, AstNode>(){

                @Override
                public AstNode apply(AstNode input) {
                    return new LabeledStatement(labelInfo.name, (Statement)input);
                }
            });
        }
        return true;
    }

    private AssessForLoopResult assessForLoop(AstNode commonAncestor, List<Stack<AstNode>> paths, LabelStatement label, List<GotoStatement> statements) {
        HashSet<GotoStatement> gotoStatements = new HashSet<GotoStatement>(statements);
        HashSet<GotoStatement> continueStatements = new HashSet<GotoStatement>();
        HashSet<ContinueStatement> preexistingContinueStatements = new HashSet<ContinueStatement>();
        boolean labelSeen = false;
        boolean loopEncountered = false;
        for (Stack<AstNode> path : paths) {
            if (CollectionUtilities.firstOrDefault(path) != label && (loopEncountered = CollectionUtilities.any(path, new Predicate<AstNode>(){

                @Override
                public boolean test(AstNode node) {
                    return AstNode.isLoop(node);
                }
            }))) break;
        }
        for (AstNode node : commonAncestor.getDescendantsAndSelf()) {
            if (node == label) {
                labelSeen = true;
                continue;
            }
            if (labelSeen && node instanceof GotoStatement && gotoStatements.contains(node)) {
                continueStatements.add((GotoStatement)node);
                continue;
            }
            if (!(node instanceof ContinueStatement) || !StringUtilities.isNullOrEmpty(((ContinueStatement)node).getLabel())) continue;
            preexistingContinueStatements.add((ContinueStatement)node);
        }
        return new AssessForLoopResult(loopEncountered, continueStatements, preexistingContinueStatements);
    }

    private static boolean lookAhead(AstNode start, Set<AstNode> targets) {
        for (AstNode current = start; current != null && !targets.isEmpty(); current = current.getNextSibling()) {
            if (!targets.contains(current)) continue;
            return true;
        }
        return false;
    }

    private static boolean lookBehind(AstNode start, Set<AstNode> targets) {
        for (AstNode current = start; current != null && !targets.isEmpty(); current = current.getPreviousSibling()) {
            if (!targets.contains(current)) continue;
            return true;
        }
        return false;
    }

    private BlockStatement findLowestCommonAncestorBlock(List<Stack<AstNode>> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        AstNode current = null;
        BlockStatement match = null;
        Stack<AstNode> sinceLastMatch = new Stack<AstNode>();
        block0: while (true) {
            for (Stack<AstNode> path : paths) {
                if (path.isEmpty()) break block0;
                if (current == null) {
                    current = path.peek();
                    continue;
                }
                if (path.peek() == current) continue;
                break block0;
            }
            for (Stack<AstNode> path : paths) {
                path.pop();
            }
            if (current instanceof BlockStatement) {
                sinceLastMatch.clear();
                match = (BlockStatement)current;
            } else {
                sinceLastMatch.push(current);
            }
            current = null;
        }
        while (!sinceLastMatch.isEmpty()) {
            int n = paths.size();
            for (int i = 0; i < n; ++i) {
                paths.get(i).push((AstNode)sinceLastMatch.peek());
            }
            sinceLastMatch.pop();
        }
        return match;
    }

    private Statement findLowestCommonAncestor(List<Stack<AstNode>> paths) {
        if (paths.isEmpty()) {
            return null;
        }
        AstNode current = null;
        Statement match = null;
        Stack<AstNode> sinceLastMatch = new Stack<AstNode>();
        block0: while (true) {
            for (Stack<AstNode> path : paths) {
                if (path.isEmpty()) break block0;
                if (current == null) {
                    current = path.peek();
                    continue;
                }
                if (path.peek() == current) continue;
                break block0;
            }
            for (Stack<AstNode> path : paths) {
                path.pop();
            }
            if (current instanceof Statement) {
                sinceLastMatch.clear();
                match = (Statement)current;
            } else {
                sinceLastMatch.push(current);
            }
            current = null;
        }
        while (!sinceLastMatch.isEmpty()) {
            int n = paths.size();
            for (int i = 0; i < n; ++i) {
                paths.get(i).push((AstNode)sinceLastMatch.peek());
            }
            sinceLastMatch.pop();
        }
        return match;
    }

    private Stack<AstNode> buildPath(AstNode node) {
        assert (node != null);
        Stack<AstNode> path = new Stack<AstNode>();
        path.push(node);
        for (AstNode current = node; current != null; current = current.getParent()) {
            path.push(current);
            if (current instanceof MethodDeclaration) break;
        }
        return path;
    }

    private static final class AssessForLoopResult {
        final boolean needsLabel;
        final Set<GotoStatement> continueStatements;
        final Set<ContinueStatement> preexistingContinueStatements;

        private AssessForLoopResult(boolean needsLabel, Set<GotoStatement> continueStatements, Set<ContinueStatement> preexistingContinueStatements) {
            this.needsLabel = needsLabel;
            this.continueStatements = continueStatements;
            this.preexistingContinueStatements = preexistingContinueStatements;
        }
    }

    private static final class LabelInfo {
        final String name;
        final List<GotoStatement> gotoStatements = new ArrayList<GotoStatement>();
        boolean labelIsLast;
        LabelStatement label;
        AstNode labelTarget;
        LabeledStatement newLabeledStatement;

        LabelInfo(String name) {
            this.name = name;
        }

        LabelInfo(LabelStatement label) {
            this.label = label;
            this.labelTarget = label.getNextSibling();
            this.name = label.getLabel();
        }
    }
}

