/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.ArrayType;
import com.strobel.assembler.metadata.CapturedType;
import com.strobel.assembler.metadata.CommonTypeReferences;
import com.strobel.assembler.metadata.CompoundTypeReference;
import com.strobel.assembler.metadata.DefaultTypeVisitor;
import com.strobel.assembler.metadata.FieldMetadataVisitor;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.GenericMethodInstance;
import com.strobel.assembler.metadata.GenericParameter;
import com.strobel.assembler.metadata.IGenericInstance;
import com.strobel.assembler.metadata.MetadataHelper;
import com.strobel.assembler.metadata.MetadataResolver;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodMetadataVisitor;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.ParameterDefinition;
import com.strobel.assembler.metadata.PrimitiveType;
import com.strobel.assembler.metadata.RawType;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.assembler.metadata.WildcardType;
import com.strobel.core.ArrayUtilities;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public final class TypeSubstitutionVisitor
extends DefaultTypeVisitor<Map<TypeReference, TypeReference>, TypeReference>
implements MethodMetadataVisitor<Map<TypeReference, TypeReference>, MethodReference>,
FieldMetadataVisitor<Map<TypeReference, TypeReference>, FieldReference> {
    private static final TypeSubstitutionVisitor INSTANCE = new TypeSubstitutionVisitor();

    public static TypeSubstitutionVisitor instance() {
        return INSTANCE;
    }

    @Override
    public TypeReference visit(TypeReference t, Map<TypeReference, TypeReference> map) {
        if (map.isEmpty()) {
            return t;
        }
        return t.accept(this, map);
    }

    @Override
    public TypeReference visitArrayType(ArrayType t, Map<TypeReference, TypeReference> map) {
        TypeReference elementType = this.visit(t.getElementType(), map);
        if (elementType != null && elementType != t.getElementType()) {
            return elementType.makeArrayType();
        }
        return t;
    }

    @Override
    public TypeReference visitGenericParameter(GenericParameter t, Map<TypeReference, TypeReference> map) {
        TypeReference mappedType;
        TypeReference current = t;
        while ((mappedType = map.get(current)) != null && mappedType != current && map.get(mappedType) != current) {
            current = mappedType;
        }
        if (current == null) {
            return t;
        }
        if (((TypeReference)current).isPrimitive()) {
            switch (((TypeReference)current).getSimpleType()) {
                case Boolean: {
                    return CommonTypeReferences.Boolean;
                }
                case Byte: {
                    return CommonTypeReferences.Byte;
                }
                case Character: {
                    return CommonTypeReferences.Character;
                }
                case Short: {
                    return CommonTypeReferences.Short;
                }
                case Integer: {
                    return CommonTypeReferences.Integer;
                }
                case Long: {
                    return CommonTypeReferences.Long;
                }
                case Float: {
                    return CommonTypeReferences.Float;
                }
                case Double: {
                    return CommonTypeReferences.Double;
                }
                case Void: {
                    return CommonTypeReferences.Void;
                }
            }
        }
        return current;
    }

    @Override
    public TypeReference visitWildcard(WildcardType t, Map<TypeReference, TypeReference> map) {
        if (t.isUnbounded()) {
            return t;
        }
        TypeReference oldBound = t.hasExtendsBound() ? t.getExtendsBound() : t.getSuperBound();
        TypeReference mapping = map.get(oldBound);
        if (MetadataResolver.areEquivalent(mapping, t)) {
            return t;
        }
        TypeReference newBound = this.visit(oldBound, map);
        while (newBound.isWildcardType()) {
            if (newBound.isUnbounded()) {
                return newBound;
            }
            newBound = newBound.hasExtendsBound() ? newBound.getExtendsBound() : newBound.getSuperBound();
        }
        if (oldBound != newBound) {
            return t.hasExtendsBound() ? WildcardType.makeExtends(newBound) : WildcardType.makeSuper(newBound);
        }
        return t;
    }

    @Override
    public TypeReference visitCompoundType(CompoundTypeReference t, Map<TypeReference, TypeReference> map) {
        TypeReference oldBaseType = t.getBaseType();
        TypeReference newBaseType = oldBaseType != null ? this.visit(oldBaseType, map) : null;
        TypeReference[] newInterfaces = null;
        boolean changed = newBaseType != oldBaseType;
        List<TypeReference> oldInterfaces = t.getInterfaces();
        for (int i = 0; i < oldInterfaces.size(); ++i) {
            TypeReference oldInterface = oldInterfaces.get(i);
            TypeReference newInterface = this.visit(oldInterface, map);
            if (newInterfaces != null) {
                newInterfaces[i] = newInterface;
                continue;
            }
            if (oldInterface == newInterface) continue;
            newInterfaces = new TypeReference[oldInterfaces.size()];
            oldInterfaces.toArray(newInterfaces);
            newInterfaces[i] = newInterface;
            changed = true;
        }
        if (changed) {
            return new CompoundTypeReference(newBaseType, newInterfaces != null ? ArrayUtilities.asUnmodifiableList(newInterfaces) : t.getInterfaces());
        }
        return t;
    }

    @Override
    public TypeReference visitParameterizedType(TypeReference t, Map<TypeReference, TypeReference> map) {
        List<TypeReference> oldTypeArguments = ((IGenericInstance)((Object)t)).getTypeArguments();
        TypeReference[] newTypeArguments = null;
        boolean changed = false;
        for (int i = 0; i < oldTypeArguments.size(); ++i) {
            TypeReference oldTypeArgument = oldTypeArguments.get(i);
            TypeReference newTypeArgument = this.visit(oldTypeArgument, map);
            if (newTypeArguments != null) {
                newTypeArguments[i] = newTypeArgument;
                continue;
            }
            if (oldTypeArgument == newTypeArgument) continue;
            newTypeArguments = new TypeReference[oldTypeArguments.size()];
            oldTypeArguments.toArray(newTypeArguments);
            newTypeArguments[i] = newTypeArgument;
            changed = true;
        }
        if (changed) {
            return t.makeGenericType(newTypeArguments);
        }
        return t;
    }

    @Override
    public TypeReference visitPrimitiveType(PrimitiveType t, Map<TypeReference, TypeReference> map) {
        return t;
    }

    @Override
    public TypeReference visitClassType(TypeReference t, Map<TypeReference, TypeReference> map) {
        TypeReference resolvedType;
        TypeReference typeReference = resolvedType = t.isGenericType() ? t : t.resolve();
        if (resolvedType == null || !resolvedType.isGenericDefinition()) {
            return t;
        }
        List<GenericParameter> oldTypeArguments = resolvedType.getGenericParameters();
        TypeReference[] newTypeArguments = null;
        boolean changed = false;
        for (int i = 0; i < oldTypeArguments.size(); ++i) {
            TypeReference oldTypeArgument = oldTypeArguments.get(i);
            TypeReference newTypeArgument = this.visit(oldTypeArgument, map);
            if (newTypeArguments != null) {
                newTypeArguments[i] = newTypeArgument;
                continue;
            }
            if (oldTypeArgument == newTypeArgument) continue;
            newTypeArguments = new TypeReference[oldTypeArguments.size()];
            oldTypeArguments.toArray(newTypeArguments);
            newTypeArguments[i] = newTypeArgument;
            changed = true;
        }
        if (changed) {
            return t.makeGenericType(newTypeArguments);
        }
        return t;
    }

    @Override
    public TypeReference visitNullType(TypeReference t, Map<TypeReference, TypeReference> map) {
        return t;
    }

    @Override
    public TypeReference visitBottomType(TypeReference t, Map<TypeReference, TypeReference> map) {
        return t;
    }

    @Override
    public TypeReference visitRawType(RawType t, Map<TypeReference, TypeReference> map) {
        return t;
    }

    @Override
    public MethodReference visitParameterizedMethod(MethodReference m3, Map<TypeReference, TypeReference> map) {
        return this.visitMethod(m3, map);
    }

    @Override
    public MethodReference visitMethod(MethodReference m3, Map<TypeReference, TypeReference> map) {
        MethodDefinition resolvedMethod = m3.resolve();
        List<TypeReference> oldTypeArguments = m3 instanceof IGenericInstance ? ((IGenericInstance)((Object)m3)).getTypeArguments() : (m3.isGenericDefinition() ? m3.getGenericParameters() : Collections.emptyList());
        List<TypeReference> newTypeArguments = this.visitTypes(oldTypeArguments, map);
        TypeReference oldReturnType = m3.getReturnType();
        TypeReference newReturnType = this.visit(oldReturnType, map);
        List<ParameterDefinition> oldParameters = m3.getParameters();
        List<ParameterDefinition> newParameters = this.visitParameters(oldParameters, map);
        if (newTypeArguments != oldTypeArguments || newReturnType != oldReturnType || newParameters != oldParameters) {
            return new GenericMethodInstance(this.visit(m3.getDeclaringType(), map), resolvedMethod != null ? resolvedMethod : m3, newReturnType, newParameters == oldParameters ? MetadataHelper.copyParameters(oldParameters) : newParameters, newTypeArguments);
        }
        return m3;
    }

    @Override
    public TypeReference visitCapturedType(CapturedType t, Map<TypeReference, TypeReference> map) {
        TypeReference oldExtendsBound = t.getExtendsBound();
        TypeReference oldSuperBound = t.getSuperBound();
        WildcardType oldWildcard = t.getWildcard();
        TypeReference newExtendsBound = this.visit(oldExtendsBound, map);
        TypeReference newSuperBound = this.visit(oldSuperBound, map);
        TypeReference newWildcard = this.visitWildcard(oldWildcard, map);
        if (newExtendsBound != oldExtendsBound || newSuperBound != oldSuperBound || newWildcard != oldWildcard) {
            return new CapturedType(newSuperBound, newExtendsBound, (WildcardType)newWildcard);
        }
        return t;
    }

    protected List<TypeReference> visitTypes(List<TypeReference> types, Map<TypeReference, TypeReference> map) {
        TypeReference[] newTypes = null;
        boolean changed = false;
        for (int i = 0; i < types.size(); ++i) {
            TypeReference oldTypeArgument = types.get(i);
            TypeReference newTypeArgument = this.visit(oldTypeArgument, map);
            if (newTypes != null) {
                newTypes[i] = newTypeArgument;
                continue;
            }
            if (oldTypeArgument == newTypeArgument) continue;
            newTypes = new TypeReference[types.size()];
            types.toArray(newTypes);
            newTypes[i] = newTypeArgument;
            changed = true;
        }
        return changed ? ArrayUtilities.asUnmodifiableList(newTypes) : types;
    }

    protected List<ParameterDefinition> visitParameters(List<ParameterDefinition> parameters, Map<TypeReference, TypeReference> map) {
        if (parameters.isEmpty()) {
            return parameters;
        }
        ParameterDefinition[] newParameters = null;
        boolean changed = false;
        for (int i = 0; i < parameters.size(); ++i) {
            TypeReference newType;
            ParameterDefinition newParameter;
            ParameterDefinition oldParameter = parameters.get(i);
            TypeReference oldType = oldParameter.getParameterType();
            ParameterDefinition parameterDefinition = newParameter = oldType != (newType = this.visit(oldType, map)) ? new ParameterDefinition(oldParameter.getSlot(), newType) : oldParameter;
            if (newParameters != null) {
                newParameters[i] = newParameter;
                continue;
            }
            if (oldType == newType) continue;
            newParameters = new ParameterDefinition[parameters.size()];
            parameters.toArray(newParameters);
            newParameters[i] = newParameter;
            changed = true;
        }
        return changed ? ArrayUtilities.asUnmodifiableList(newParameters) : parameters;
    }

    @Override
    public FieldReference visitField(final FieldReference f, Map<TypeReference, TypeReference> map) {
        TypeReference oldFieldType = f.getFieldType();
        final TypeReference newFieldType = this.visit(oldFieldType, map);
        if (newFieldType != oldFieldType) {
            final TypeReference declaringType = f.getDeclaringType();
            return new FieldReference(){
                private final String _name;
                private final TypeReference _type;
                {
                    this._name = f.getName();
                    this._type = newFieldType;
                }

                @Override
                public TypeReference getFieldType() {
                    return this._type;
                }

                @Override
                public TypeReference getDeclaringType() {
                    return declaringType;
                }

                @Override
                public String getName() {
                    return this._name;
                }

                @Override
                protected StringBuilder appendName(StringBuilder sb, boolean fullName, boolean dottedName) {
                    TypeReference declaringType2;
                    if (fullName && (declaringType2 = this.getDeclaringType()) != null) {
                        return declaringType2.appendName(sb, true, false).append('.').append(this.getName());
                    }
                    return sb.append(this._name);
                }
            };
        }
        return f;
    }
}

