/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.assembler.metadata;

import com.strobel.assembler.metadata.BuiltinTypes;
import com.strobel.assembler.metadata.TypeMetadataVisitor;
import com.strobel.assembler.metadata.TypeReference;
import java.util.List;

public final class CompoundTypeReference
extends TypeReference {
    private final TypeReference _baseType;
    private final List<TypeReference> _interfaces;

    public CompoundTypeReference(TypeReference baseType, List<TypeReference> interfaces) {
        this._baseType = baseType;
        this._interfaces = interfaces;
    }

    public final TypeReference getBaseType() {
        return this._baseType;
    }

    public final List<TypeReference> getInterfaces() {
        return this._interfaces;
    }

    @Override
    public TypeReference getDeclaringType() {
        return null;
    }

    @Override
    public String getSimpleName() {
        if (this._baseType != null) {
            return this._baseType.getSimpleName();
        }
        return this._interfaces.get(0).getSimpleName();
    }

    @Override
    public boolean containsGenericParameters() {
        TypeReference baseType = this.getBaseType();
        if (baseType != null && baseType.containsGenericParameters()) {
            return true;
        }
        for (TypeReference t : this._interfaces) {
            if (!t.containsGenericParameters()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        if (this._baseType != null) {
            return this._baseType.getName();
        }
        return this._interfaces.get(0).getName();
    }

    @Override
    public String getFullName() {
        if (this._baseType != null) {
            return this._baseType.getFullName();
        }
        return this._interfaces.get(0).getFullName();
    }

    @Override
    public String getInternalName() {
        if (this._baseType != null) {
            return this._baseType.getInternalName();
        }
        return this._interfaces.get(0).getInternalName();
    }

    @Override
    public final <R, P> R accept(TypeMetadataVisitor<P, R> visitor, P parameter) {
        return visitor.visitCompoundType(this, parameter);
    }

    @Override
    public StringBuilder appendBriefDescription(StringBuilder sb) {
        TypeReference baseType = this._baseType;
        List<TypeReference> interfaces = this._interfaces;
        StringBuilder s2 = sb;
        if (baseType != null) {
            s2 = baseType.appendBriefDescription(s2);
            if (!interfaces.isEmpty()) {
                s2.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s2.append(" & ");
            }
            s2 = interfaces.get(i).appendBriefDescription(s2);
        }
        return s2;
    }

    @Override
    public StringBuilder appendSimpleDescription(StringBuilder sb) {
        TypeReference baseType = this._baseType;
        List<TypeReference> interfaces = this._interfaces;
        StringBuilder s2 = sb;
        if (baseType != null) {
            s2 = baseType.appendSimpleDescription(s2);
            if (!interfaces.isEmpty()) {
                s2.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s2.append(" & ");
            }
            s2 = interfaces.get(i).appendSimpleDescription(s2);
        }
        return s2;
    }

    @Override
    public StringBuilder appendErasedDescription(StringBuilder sb) {
        TypeReference baseType = this._baseType;
        List<TypeReference> interfaces = this._interfaces;
        StringBuilder s2 = sb;
        if (baseType != null) {
            s2 = baseType.appendErasedDescription(s2);
            if (!interfaces.isEmpty()) {
                s2.append(" & ");
            }
        }
        int n = interfaces.size();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                s2.append(" & ");
            }
            s2 = interfaces.get(i).appendErasedDescription(s2);
        }
        return s2;
    }

    @Override
    public StringBuilder appendDescription(StringBuilder sb) {
        return this.appendBriefDescription(sb);
    }

    @Override
    public StringBuilder appendSignature(StringBuilder sb) {
        StringBuilder s2 = sb;
        if (this._baseType != null) {
            s2 = this._baseType.appendSignature(s2);
        }
        if (this._interfaces.isEmpty()) {
            return s2;
        }
        for (TypeReference interfaceType : this._interfaces) {
            s2.append(':');
            s2 = interfaceType.appendSignature(s2);
        }
        return s2;
    }

    @Override
    public StringBuilder appendErasedSignature(StringBuilder sb) {
        if (this._baseType != null) {
            return this._baseType.appendErasedSignature(sb);
        }
        if (!this._interfaces.isEmpty()) {
            return this._interfaces.get(0).appendErasedSignature(sb);
        }
        return BuiltinTypes.Object.appendErasedSignature(sb);
    }
}

